package com.miam.sdk.components.catalog

import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfig
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfigBuilder
import com.miam.sdk.components.baseComponent.loader.LoaderConfig
import com.miam.sdk.components.baseComponent.loader.LoaderConfigBuilder
import com.miam.sdk.components.catalog.success.CatalogSuccessConfig
import com.miam.sdk.components.catalog.success.CatalogSuccessConfigBuilder
import com.miam.sdk.components.catalog.success.categoriesPage.category.CatalogCategoriesPageCategoryConfig
import com.miam.sdk.components.catalog.success.categoriesPage.category.CatalogCategoriesPageCategoryConfigBuilder
import com.miam.sdk.components.catalog.success.toolbar.CatalogSuccessToolbarConfig
import com.miam.sdk.components.catalog.success.toolbar.CatalogSuccessToolbarConfigBuilder

class CatalogConfigBuilder {

    var category: CatalogCategoriesPageCategoryConfig = CatalogCategoriesPageCategoryConfig()
    var toolbar: CatalogSuccessToolbarConfig = CatalogSuccessToolbarConfig()
    var empty: EmptyPageConfig? = null
    var success: CatalogSuccessConfig = CatalogSuccessConfig()
    var loader: LoaderConfig? = null


    inline fun category(init: CatalogCategoriesPageCategoryConfigBuilder.() -> Unit) {
        this.category = CatalogCategoriesPageCategoryConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun toolbar(init: CatalogSuccessToolbarConfigBuilder.() -> Unit) {
        this.toolbar = CatalogSuccessToolbarConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loader(init: LoaderConfigBuilder.() -> Unit) {
        this.loader = LoaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: EmptyPageConfigBuilder.() -> Unit) {
        this.empty = EmptyPageConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun success(init: CatalogSuccessConfigBuilder.() -> Unit) {
        this.success = CatalogSuccessConfigBuilder()
            .apply(init)
            .build()
    }


    @PublishedApi
    internal fun build(): CatalogConfig {
        return CatalogConfig(
            success,
            loader,
            empty
        )
    }
}