package com.miam.sdk.components.baseComponent.filter

import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.collectAsState
import com.miam.core.model.CatalogFilterOptions
import com.miam.core.viewModels.catalog.CatalogFilterViewModelFactory
import com.miam.core.viewModels.filter.FilterContract
import com.miam.sdk.components.baseComponent.filter.success.FilterSuccessParameters
import com.miam.sdk.di.TemplateDI


class Filter(
    private val pageName: String,
    private val closeDialog: () -> Unit,
    private val goToFilterResult: () -> Unit
) {
    private val filterVM = CatalogFilterViewModelFactory().instantiate(pageName)

    private fun onCostFilterChanged(catOption: CatalogFilterOptions) {
        filterVM.setEvent(FilterContract.Event.OnCostFilterChanged(catOption))
    }

    private fun onTimeFilterChanged(catOption: CatalogFilterOptions) {
        filterVM.setEvent(FilterContract.Event.OnTimeFilterChanged(catOption))
    }

    private fun onDifficultyChanged(catOption: CatalogFilterOptions) {
        filterVM.setEvent(FilterContract.Event.OnDifficultyChanged(catOption))
    }

    private fun clearFilter() {
        filterVM.clear()
    }

    private fun applyAndGo() {
        filterVM.applyFilter()
        //we should add this line when RouteService will be removed : pre-instantiate the view Model before navigating
        //CatalogFilterViewModelFactory().instantiate("CatalogFilterViewModel")
        goToFilterResult()
    }

    @Composable
    fun Content() {
        val state = filterVM.uiState.collectAsState()
        DisposableEffect(Unit) { onDispose { CatalogFilterViewModelFactory().abolishInstance("Catalog") } }
        TemplateDI.filter.success.view.Content(
            params = FilterSuccessParameters(
                difficulties = state.value.difficulty,
                costs = state.value.cost,
                times = state.value.time,
                onCostFilterChanged = ::onCostFilterChanged,
                onTimeFilterChanged = ::onTimeFilterChanged,
                onDifficultyChanged = ::onDifficultyChanged,
                clearFilter = ::clearFilter,
                applyAndGo = ::applyAndGo,
                closeDialog = closeDialog,
                numberOfResult = state.value.numberOfResult
            )
        )
    }
}