package com.miam.kmm_miam_sdk.android.ui.components.preferences

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material.CircularProgressIndicator
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Colors.white
import com.miam.kmm_miam_sdk.android.theme.Template

@Composable
fun PreferencesLoadingView() {
    if (Template.PreferencesLoadingTemplate != null) {
        Template.PreferencesLoadingTemplate?.let { it() }
    } else {
        Column(
            Modifier
                .fillMaxSize()
                .background(color = white),
            horizontalAlignment = Alignment.CenterHorizontally,
            verticalArrangement = Arrangement.Center
        ) {
            CircularProgressIndicator(color = Colors.primary)
        }
    }
}