package com.miam.sdk.di

import com.miam.sdk.templatesConfigs.TemplatesConfigs
import com.miam.sdk.templatesConfigs.mealPlanner.MealPlannerConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.empty.MealPlannerBasketPreviewEmptyConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.footer.MealPlannerBasketPreviewFooterConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.loading.MealPlannerBasketPreviewLoadingConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.product.MealPlannerBasketPreviewProductConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.recipeOverview.MealPlannerBasketPreviewRecipeOverviewConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.sectionProduct.MealPlannerBasketPreviewSectionProductConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.sectionTitle.MealPlannerBasketPreviewSectionTitleConfig
import com.miam.sdk.templatesConfigs.mealPlanner.callToAction.MealPlannerCallToActionConfig
import com.miam.sdk.templatesConfigs.mealPlanner.form.MealPlannerFormConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.empty.MealPlannerEmptyConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.footer.MealPlannerFooterConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.loading.MealPlannerLoadingConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.toolbar.MealPlannerToolbarConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recap.MealPlannerRecapConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.card.MealPlannerRecipeCardConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.loading.MealPlannerRecipeLoadingConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.placeholder.MealPlannerRecipePlaceholderConfig
import com.miam.sdk.templatesConfigs.mealPlanner.search.MealPlannerSearchConfig
import com.miam.sdk.templatesConfigs.mealPlanner.search.MealPlannerSearchEmptyConfig

object TemplateDI {

    internal val templates: TemplatesConfigs by lazy { TemplatesConfigs.getInstance() }
    
    ///////// MEAL PLANNER /////////////

    internal val mealPlanner: MealPlannerConfig by lazy { templates.mealPlanner }
    internal val mealPlannerForm: MealPlannerFormConfig by lazy { mealPlanner.form }
    internal val mealPlannerCallToActionButton: MealPlannerCallToActionConfig by lazy { mealPlanner.callToAction }
    internal val mealPlannerEmpty: MealPlannerEmptyConfig by lazy { mealPlanner.plannerEmpty }
    internal val mealPlannerFooter: MealPlannerFooterConfig by lazy { mealPlanner.plannerFooter }
    internal val mealPlannerLoading: MealPlannerLoadingConfig by lazy { mealPlanner.plannerLoading }
    internal val mealPlannerToolbar: MealPlannerToolbarConfig by lazy { mealPlanner.plannerToolbar }
    internal val mealPlannerRecipeCard: MealPlannerRecipeCardConfig by lazy { mealPlanner.recipeCard }
    internal val mealPlannerRecipePlaceholder: MealPlannerRecipePlaceholderConfig by lazy { mealPlanner.recipePlaceholder }
    internal val mealPlannerRecipeLoading: MealPlannerRecipeLoadingConfig by lazy { mealPlanner.recipeLoading }
    internal val mealPlannerBasketPreviewEmpty: MealPlannerBasketPreviewEmptyConfig by lazy { mealPlanner.basketPreviewEmpty }
    internal val mealPlannerBasketPreviewLoading: MealPlannerBasketPreviewLoadingConfig by lazy { mealPlanner.basketPreviewLoading }
    internal val mealPlannerBasketPreviewProduct: MealPlannerBasketPreviewProductConfig by lazy { mealPlanner.basketPreviewProduct }
    internal val mealPlannerBasketPreviewFooter: MealPlannerBasketPreviewFooterConfig by lazy { mealPlanner.basketPreviewFooter }
    internal val mealPlannerBasketPreviewRecipeOverview: MealPlannerBasketPreviewRecipeOverviewConfig by lazy { mealPlanner.basketPreviewRecipeOverview }
    internal val mealPlannerBasketPreviewSectionProduct: MealPlannerBasketPreviewSectionProductConfig by lazy { mealPlanner.basketPreviewSectionProduct }
    internal val mealPlannerBasketPreviewSectionTitle: MealPlannerBasketPreviewSectionTitleConfig by lazy { mealPlanner.basketPreviewSectionTitle }
    internal val mealSearch: MealPlannerSearchConfig by lazy { mealPlanner.search }
    internal val searchEmpty: MealPlannerSearchEmptyConfig by lazy { mealPlanner.searchEmpty }
    internal val mealPlannerRecap: MealPlannerRecapConfig by lazy { mealPlanner.recap }

    ///////////////////////////////////
}