package com.miam.kmm_miam_sdk.android.ui.components.likeButton


import androidx.compose.animation.Crossfade
import androidx.compose.animation.core.tween
import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material.Surface
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.miam.kmmMiamCore.component.recipeLike.LikeButtonViewModel
import com.miam.kmm_miam_sdk.android.theme.Template
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable
import com.miam.kmm_miam_sdk.android.ui.components.likeButton.LikeButtonColor.buttonBackgroundColor
import com.miam.kmm_miam_sdk.android.ui.components.likeButton.LikeButtonStyle.iconModifier
import com.miam.kmm_miam_sdk.android.ui.components.states.ManagementResourceState

class LikeButton(private val backgroundShape: Shape = CircleShape, Content: (@Composable (action: () -> Unit) -> Unit)? = null) {

    private val likeButtonViewModel = LikeButtonViewModel()

    fun bind(recipeId: String) {
        likeButtonViewModel.setRecipe(recipeId)
    }

    @Composable
    fun Content() {
        DisposableEffect(Unit) { onDispose { likeButtonViewModel.dispose() } }
        val state by likeButtonViewModel.uiState.collectAsState()

        ManagementResourceState(
            resourceState = state.isLiked,
            successView = { isLiked ->
                requireNotNull(isLiked)
                if (Template.LikeButtonTemplate != null) {
                    Template.LikeButtonTemplate?.let { it(isLiked) { likeButtonViewModel.toggleLike() } }
                } else {
                    RecipeLikeSuccessButton({ likeButtonViewModel.toggleLike() }, isLiked, backgroundShape)
                }
            },
            loadingView = {
                RecipeLikeSuccessButton({}, false, backgroundShape)
            },
            emptyView = {
                //TODO
            }
        )
    }

    @Composable
    fun RecipeLikeSuccessButton(toggleLike: () -> Unit, isLiked: Boolean, backgroundShape: Shape) {
        var currentIsLiked by remember { mutableStateOf(isLiked) }

        Clickable(onClick = toggleLike) {
            Surface(shape = backgroundShape) {
                Box(
                    Modifier
                        .background(buttonBackgroundColor)
                        .padding(8.dp)
                )
                {
                    Crossfade(targetState = currentIsLiked, animationSpec = tween(750, 0)) { currentIsLiked ->
                        if (currentIsLiked) {
                            Image(
                                painter = painterResource(LikeButtonImage.favoriteFilled),
                                contentDescription = "favorite",
                                modifier = iconModifier,
                            )
                        } else {
                            Image(
                                painter = painterResource(LikeButtonImage.favorite),
                                contentDescription = "favorite",
                                modifier = iconModifier,
                            )
                        }
                    }
                }
            }
        }
    }
}