package com.miam.sdk.components.mealPlanner.callToAction

import android.content.Context
import android.util.AttributeSet
import androidx.compose.runtime.Composable
import androidx.compose.ui.platform.AbstractComposeView
import com.miam.sdk.di.TemplateDI
import com.miam.sdk.templateParameters.mealPlanner.callToAction.MealPlannerCallToActionParameters

class MealPlannerCallToAction @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    private var action = {}

    fun bind(action: () -> Unit) {
        this.action = action
    }

    @Composable
    override fun Content() {
        TemplateDI.mealPlannerCallToActionButton.view.Content(mealPlannerCallToActionParameters = MealPlannerCallToActionParameters {
            action()
        })
    }

}