package com.miam.sdk.templatesConfigs.mealPlanner

import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.empty.MealPlannerBasketPreviewEmptyConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.empty.MealPlannerBasketPreviewEmptyConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.footer.MealPlannerBasketPreviewFooterConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.footer.MealPlannerBasketPreviewFooterConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.loading.MealPlannerBasketPreviewLoadingConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.loading.MealPlannerBasketPreviewLoadingConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.product.MealPlannerBasketPreviewProductConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.product.MealPlannerBasketPreviewProductConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.recipeOverview.MealPlannerBasketPreviewRecipeOverviewConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.recipeOverview.MealPlannerBasketPreviewRecipeOverviewConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.sectionProduct.MealPlannerBasketPreviewSectionProductConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.sectionProduct.MealPlannerBasketPreviewSectionProductConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.sectionTitle.MealPlannerBasketPreviewSectionTitleConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.sectionTitle.MealPlannerBasketPreviewSectionTitleConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.callToAction.MealPlannerCallToActionConfig
import com.miam.sdk.templatesConfigs.mealPlanner.callToAction.MealPlannerCallToActionConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.form.MealPlannerFormConfig
import com.miam.sdk.templatesConfigs.mealPlanner.form.MealPlannerFormConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.planner.empty.MealPlannerEmptyConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.empty.MealPlannerEmptyConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.planner.footer.MealPlannerFooterConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.footer.MealPlannerFooterConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.planner.loading.MealPlannerLoadingConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.loading.MealPlannerLoadingConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.planner.toolbar.MealPlannerToolbarConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.toolbar.MealPlannerToolbarConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.recap.MealPlannerRecapConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recap.MealPlannerRecapConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.card.MealPlannerRecipeCardConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.card.MealPlannerRecipeCardConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.loading.MealPlannerRecipeLoadingConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.loading.MealPlannerRecipeLoadingConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.placeholder.MealPlannerRecipePlaceholderConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.placeholder.MealPlannerRecipePlaceholderConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.search.MealPlannerSearchConfig
import com.miam.sdk.templatesConfigs.mealPlanner.search.MealPlannerSearchConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.search.MealPlannerSearchEmptyConfig
import com.miam.sdk.templatesConfigs.mealPlanner.search.MealPlannerSearchEmptyConfigBuilder

class MealPlannerConfigBuilder {

    var recipeCardConfig: MealPlannerRecipeCardConfig = MealPlannerRecipeCardConfig()
    var recipePlaceholderConfig: MealPlannerRecipePlaceholderConfig = MealPlannerRecipePlaceholderConfig()
    var recipeLoadingConfig: MealPlannerRecipeLoadingConfig = MealPlannerRecipeLoadingConfig()
    var basketPreviewEmptyConfig: MealPlannerBasketPreviewEmptyConfig = MealPlannerBasketPreviewEmptyConfig()
    var basketPreviewSectionTitleConfig: MealPlannerBasketPreviewSectionTitleConfig = MealPlannerBasketPreviewSectionTitleConfig()
    var basketPreviewSectionProductConfig: MealPlannerBasketPreviewSectionProductConfig = MealPlannerBasketPreviewSectionProductConfig()
    var basketPreviewRecipeOverviewConfig: MealPlannerBasketPreviewRecipeOverviewConfig = MealPlannerBasketPreviewRecipeOverviewConfig()
    var basketPreviewFooterConfig: MealPlannerBasketPreviewFooterConfig = MealPlannerBasketPreviewFooterConfig()
    var basketPreviewLoadingConfig: MealPlannerBasketPreviewLoadingConfig = MealPlannerBasketPreviewLoadingConfig()
    var basketPreviewProductConfig: MealPlannerBasketPreviewProductConfig = MealPlannerBasketPreviewProductConfig()
    var callToActionConfig: MealPlannerCallToActionConfig = MealPlannerCallToActionConfig()
    var formConfig: MealPlannerFormConfig = MealPlannerFormConfig()
    var searchConfig: MealPlannerSearchConfig = MealPlannerSearchConfig()
    var searchEmpty: MealPlannerSearchEmptyConfig = MealPlannerSearchEmptyConfig()
    var recapConfig: MealPlannerRecapConfig = MealPlannerRecapConfig()
    var plannerEmptyConfig: MealPlannerEmptyConfig = MealPlannerEmptyConfig()
    var plannerFooterConfig: MealPlannerFooterConfig = MealPlannerFooterConfig()
    var plannerLoadingConfig: MealPlannerLoadingConfig = MealPlannerLoadingConfig()
    var plannerToolbarConfig: MealPlannerToolbarConfig = MealPlannerToolbarConfig()


    inline fun recipeCardConfig(init: MealPlannerRecipeCardConfigBuilder.() -> Unit) {
        this.recipeCardConfig = MealPlannerRecipeCardConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipePlaceholderConfig(init: MealPlannerRecipePlaceholderConfigBuilder.() -> Unit) {
        this.recipePlaceholderConfig = MealPlannerRecipePlaceholderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipeLoadingConfig(init: MealPlannerRecipeLoadingConfigBuilder.() -> Unit) {
        this.recipeLoadingConfig = MealPlannerRecipeLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun basketPreviewSectionTitleConfig(init: MealPlannerBasketPreviewSectionTitleConfigBuilder.() -> Unit) {
        this.basketPreviewSectionTitleConfig = MealPlannerBasketPreviewSectionTitleConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun basketPreviewSectionProductConfig(init: MealPlannerBasketPreviewSectionProductConfigBuilder.() -> Unit) {
        this.basketPreviewSectionProductConfig = MealPlannerBasketPreviewSectionProductConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun basketPreviewRecipeOverviewConfig(init: MealPlannerBasketPreviewRecipeOverviewConfigBuilder.() -> Unit) {
        this.basketPreviewRecipeOverviewConfig = MealPlannerBasketPreviewRecipeOverviewConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun basketPreviewFooterConfig(init: MealPlannerBasketPreviewFooterConfigBuilder.() -> Unit) {
        this.basketPreviewFooterConfig = MealPlannerBasketPreviewFooterConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun basketPreviewProductConfig(init: MealPlannerBasketPreviewProductConfigBuilder.() -> Unit) {
        this.basketPreviewProductConfig = MealPlannerBasketPreviewProductConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun callToActionConfig(init: MealPlannerCallToActionConfigBuilder.() -> Unit) {
        this.callToActionConfig = MealPlannerCallToActionConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun formConfig(init: MealPlannerFormConfigBuilder.() -> Unit) {
        this.formConfig = MealPlannerFormConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun basketPreviewEmptyConfig(init: MealPlannerBasketPreviewEmptyConfigBuilder.() -> Unit) {
        this.basketPreviewEmptyConfig = MealPlannerBasketPreviewEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun basketPreviewLoadingConfig(init: MealPlannerBasketPreviewLoadingConfigBuilder.() -> Unit) {
        this.basketPreviewLoadingConfig = MealPlannerBasketPreviewLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun searchEmpty(init: MealPlannerSearchEmptyConfigBuilder.() -> Unit) {
        this.searchEmpty = MealPlannerSearchEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recapConfig(init: MealPlannerRecapConfigBuilder.() -> Unit) {
        this.recapConfig = MealPlannerRecapConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun searchConfig(init: MealPlannerSearchConfigBuilder.() -> Unit) {
        this.searchConfig = MealPlannerSearchConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun plannerEmptyConfig(init: MealPlannerEmptyConfigBuilder.() -> Unit) {
        this.plannerEmptyConfig = MealPlannerEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun plannerFooterConfig(init: MealPlannerFooterConfigBuilder.() -> Unit) {
        this.plannerFooterConfig = MealPlannerFooterConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun plannerLoadingConfig(init: MealPlannerLoadingConfigBuilder.() -> Unit) {
        this.plannerLoadingConfig = MealPlannerLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun plannerToolbarConfig(init: MealPlannerToolbarConfigBuilder.() -> Unit) {
        this.plannerToolbarConfig = MealPlannerToolbarConfigBuilder()
            .apply(init)
            .build()
    }


    @PublishedApi
    internal fun build(): MealPlannerConfig {
        return MealPlannerConfig(
            recipeCardConfig,
            recipePlaceholderConfig,
            recipeLoadingConfig,
            basketPreviewEmptyConfig,
            basketPreviewSectionTitleConfig,
            basketPreviewSectionProductConfig,
            basketPreviewRecipeOverviewConfig,
            basketPreviewFooterConfig,
            basketPreviewLoadingConfig,
            basketPreviewProductConfig,
            callToActionConfig,
            plannerEmptyConfig,
            plannerFooterConfig,
            plannerLoadingConfig,
            plannerToolbarConfig,
            formConfig,
            searchEmpty,
            searchConfig,
            recapConfig
        )
    }
}