package com.miam.sdk.ui.mealPlanner.planner

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.animation.core.FastOutSlowInEasing
import androidx.compose.animation.core.animateFloatAsState
import androidx.compose.animation.core.tween
import androidx.compose.animation.slideInVertically
import androidx.compose.animation.slideOutVertically
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Button
import androidx.compose.material.ButtonDefaults
import androidx.compose.material.Icon
import androidx.compose.material.LinearProgressIndicator
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.RectangleShape
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.miam.core.sdk.localisation.Localisation
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.sdk.templateInterfaces.mealPlanner.meals.MealPlannerFooter
import com.miam.sdk.templateParameters.mealPlanner.planner.BudgetPlannerFooterParameters
import java.text.NumberFormat
import java.util.*

internal class MealPlannerFooterImp: MealPlannerFooter {
    @Composable
    override fun Content(budgetPlannerFooterParameters: BudgetPlannerFooterParameters) {

        var ratio = budgetPlannerFooterParameters.recipesPrice / budgetPlannerFooterParameters.budget
        val isBudgetExceeded =
            if (ratio > 1) Colors.dangerBudgetText else Colors.positive
        val numberFormat = NumberFormat.getCurrencyInstance()
        numberFormat.currency = Currency.getInstance(Localisation.Price.currency.localised)

        val progressAnimation = animateFloatAsState(
            targetValue = if (ratio > 1) (budgetPlannerFooterParameters.budget / budgetPlannerFooterParameters.recipesPrice).toFloat()
            else (ratio).toFloat(),
            animationSpec = tween(durationMillis = 1500, easing = FastOutSlowInEasing)
        ).value

        AnimatedVisibility(
            visible = budgetPlannerFooterParameters.recipesPrice != 0.0,
            enter = slideInVertically { height -> height },
            exit = slideOutVertically { height -> height }
        ) {
            Column {

                Row(
                    modifier = Modifier
                        .fillMaxWidth()
                        .height(45.dp),
                    verticalAlignment = Alignment.CenterVertically
                ) {
                    if (ratio > 1) {
                        LinearProgressIndicator(
                            backgroundColor = Colors.dangerBudgetBar,
                            progress = progressAnimation,
                            modifier = Modifier
                                .height(8.dp)
                                .padding(horizontal = 32.dp)
                                .clip(RoundedCornerShape(8.dp)),
                            color = Colors.primary
                        )
                    } else {
                        LinearProgressIndicator(
                            progress = progressAnimation,
                            modifier = Modifier
                                .height(8.dp)
                                .padding(horizontal = 32.dp)
                                .clip(RoundedCornerShape(8.dp)),
                            color = Colors.primary
                        )
                    }
                    Text(
                        text = numberFormat.format(budgetPlannerFooterParameters.recipesPrice),
                        color = isBudgetExceeded,
                        style = Typography.bodyBold
                    )
                }


                Button(
                    onClick = { budgetPlannerFooterParameters.addAllToBasket() },
                    modifier = Modifier
                        .fillMaxWidth()
                        .height(45.dp),
                    colors = ButtonDefaults.buttonColors(backgroundColor = Colors.primary),
                    shape = RectangleShape,
                ) {
                    Icon(
                        painterResource(id = Image.cart),
                        contentDescription = null,
                        tint = Colors.white,
                        modifier = Modifier.size(20.dp)
                    )
                    Spacer(modifier = Modifier.width(8.dp))
                    Text(
                        text = Localisation.Recipe.add.localised,
                        color = Color.White,
                        style = Typography.body
                    )
                }
            }
        }
    }
}