package com.miam.sdk.templatesConfigs

import com.miam.sdk.templatesConfigs.mealPlanner.MealPlannerConfig
import com.miam.sdk.templatesConfigs.mealPlanner.MealPlannerConfigBuilder


object MiamTheme {
    @Suppress("FunctionName")
    inline fun Template(init: MiamThemeBuilder.() -> Unit) {
        MiamThemeBuilder()
            .apply(init)
            .build()
    }

    inline fun MiamThemeBuilder.mealPlanner(init: MealPlannerConfigBuilder.() -> Unit) {
        this.mealPlanner = MealPlannerConfigBuilder().apply(init).build()
    }

}

class MiamThemeBuilder {

    var mealPlanner: MealPlannerConfig = MealPlannerConfig()

    @PublishedApi
    internal fun build() {
        TemplatesConfigs.initialise(
            mealPlanner = mealPlanner
        )
    }
}

internal class TemplatesConfigs private constructor(val mealPlanner: MealPlannerConfig) {

    companion object {
        private var templatesConfigs: TemplatesConfigs? = null
            set(value) {
                require(field == null) { "You cannot configure the Templates Configs  twice." }
                field = value
            }

        @PublishedApi
        internal fun initialise(mealPlanner: MealPlannerConfig = MealPlannerConfig()): TemplatesConfigs {
            val tc = TemplatesConfigs(mealPlanner = mealPlanner)
            templatesConfigs = tc
            return tc
        }

        fun getInstance() = templatesConfigs ?: initialise()
    }
}