package com.miam.sdk.components.sponsorDetail

import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.heightIn
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.rotate
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import coil.compose.rememberImagePainter
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors.white
import com.miam.kmm_miam_sdk.android.theme.Dimension
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable

@Composable
fun SponsorDetailTopBar(previous: () -> Unit, sponsorLogo: String?) {
    Row(
        Modifier
            .background(white)
            .fillMaxWidth()
            .padding(8.dp),
        horizontalArrangement = Arrangement.SpaceBetween,
        verticalAlignment = Alignment.CenterVertically
    ) {
        Clickable(
            onClick = previous,
        ) {
            Image(
                painter = painterResource(Image.toggleCaret),
                contentDescription = null,
                modifier = Modifier
                    .size(40.dp)
                    .padding(end = Dimension.mPadding)
                    .rotate(180f)
            )
        }
        sponsorLogo?.let {
            Image(
                modifier = Modifier
                    .heightIn(0.dp, 96.dp),
                painter = rememberImagePainter(it),
                contentDescription = null,
                contentScale = ContentScale.Inside,
            )
        }
    }
}