package com.miam.sdk.ui.mealPlanner.search

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.text.KeyboardActions
import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.material.IconButton
import androidx.compose.material.OutlinedTextField
import androidx.compose.material.Text
import androidx.compose.material.TextFieldDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.input.ImeAction
import androidx.compose.ui.tooling.preview.Preview
import com.miam.core.sdk.localisation.Localisation
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Dimension
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.sdk.templateInterfaces.mealPlanner.search.MealPlannerSearch
import com.miam.sdk.templateParameters.mealPlanner.search.MealPlannerSearchParameters

class MealPlannerSearchImp: MealPlannerSearch {
    @Composable
    override fun Content(mealPlannerSearchParameters: MealPlannerSearchParameters) {

        var currentSearch by remember { mutableStateOf("") }

        Row(
            modifier = Modifier
                .fillMaxWidth()
                .padding(Dimension.mPadding),
            horizontalArrangement = Arrangement.SpaceBetween
        ) {
            Box(Modifier.weight(1f)) {
                SearchBarText(
                    searchText = currentSearch,
                    onTextChange = {
                        currentSearch = it
                        mealPlannerSearchParameters.updateSearch(it)
                    },
                    submit = { mealPlannerSearchParameters.updateSearch(currentSearch) }
                )
            }
            IconButton(onClick = mealPlannerSearchParameters.filtersTapped) {
                Image(
                    painter = painterResource(Image.filter),
                    contentDescription = "Filter Icon",
                    colorFilter = ColorFilter.tint(Colors.primary)
                )
            }
        }
    }


    @Composable
    fun SearchBarText(searchText: String, onTextChange: (String) -> Unit, submit: () -> Unit) {
        var isFocused by remember { mutableStateOf(false) }

        Row(
            Modifier.fillMaxWidth(),
            horizontalArrangement = Arrangement.Start
        ) {
            OutlinedTextField(
                value = searchText,
                onValueChange = onTextChange,
                placeholder = {
                    Text(text = Localisation.Budget.searchForRecipe.localised, style = Typography.bodySmall)
                },
                modifier = Modifier.fillMaxWidth(),
                leadingIcon = {
                    IconButton(onClick = { isFocused = false }) {
                        Image(
                            painter = painterResource(Image.search),
                            contentDescription = "Search Icon",
                            colorFilter = ColorFilter.tint(Colors.black)
                        )
                    }
                },
                singleLine = true,
                keyboardOptions = KeyboardOptions(imeAction = ImeAction.Done), // Show Done button on keyboard
                keyboardActions = KeyboardActions(onDone = {
                    isFocused = false
                    submit()
                }), // Call submit function when Done button is pressed
                colors = TextFieldDefaults.outlinedTextFieldColors(
                    focusedBorderColor = Colors.primary,
                    unfocusedBorderColor = Colors.lightgrey
                )
            )

        }
    }
}


@Preview()
@Composable
fun PreviewSearchBar() {
    val budgetSearch = MealPlannerSearchImp()
    var currentSearch by remember { mutableStateOf("") }
    budgetSearch.Content(
        MealPlannerSearchParameters(
            updateSearch = { newSearchValue -> currentSearch = newSearchValue },
            filtersTapped = { println("tapped filters") })
    )
}