package com.miam.kmm_miam_sdk.android.ui.components.recipeDetails.subComponents

import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.material.Divider
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.recipeDetails.RecipeDetailsImage
import com.miam.kmm_miam_sdk.android.ui.components.recipeDetails.RecipeDetailsStyle
import com.miam.kmm_miam_sdk.android.ui.components.recipeDetails.RecipeDetailsText.difficultyHigh
import com.miam.kmm_miam_sdk.android.ui.components.recipeDetails.RecipeDetailsText.difficultyLow
import com.miam.kmm_miam_sdk.android.ui.components.recipeDetails.RecipeDetailsText.difficultyMedium
import kotlin.time.Duration
import kotlin.time.DurationUnit
import kotlin.time.toDuration

@Composable
fun RecipeDifficulty(imageRef: Int, difficultyLabel: String) {
    Image(
        painter = painterResource(imageRef),
        contentDescription = null,
        modifier = RecipeDetailsStyle.difficultyIconModifier
    )
    Text(
        text = difficultyLabel,
        style = Typography.bodySmallBold
    )
}

@Composable
fun RecipeDifficultyAndTiming(
    difficulty: Int,
    totalTime: String,
    preparationTime: Duration?,
    cookingTime: Duration?,
    restingTime: Duration?
) {
    Row(
        horizontalArrangement = Arrangement.spacedBy(8.dp, Alignment.Start),
        verticalAlignment = Alignment.CenterVertically,
        modifier = Modifier.padding(start = 24.dp)
    ) {
        Column(
            verticalArrangement = Arrangement.Center,
            horizontalAlignment = Alignment.CenterHorizontally
        ) {
            Image(
                painter = painterResource(RecipeDetailsImage.time),
                contentDescription = null,
                modifier = RecipeDetailsStyle.totalTimeIcon
            )
            Text(
                text = totalTime,
                style = Typography.bodySmallBold
            )
        }
        Divider(modifier = RecipeDetailsStyle.difficultyAndTimeDivider)
        Column(
            verticalArrangement = Arrangement.Center,
            horizontalAlignment = Alignment.CenterHorizontally
        ) {
            when (difficulty) {
                1 -> RecipeDifficulty(RecipeDetailsImage.difficultyLow, difficultyLow)
                2 -> RecipeDifficulty(RecipeDetailsImage.difficultyMid, difficultyMedium)
                3 -> RecipeDifficulty(RecipeDetailsImage.difficultyHard, difficultyHigh)
            }
        }
        Divider(modifier = RecipeDetailsStyle.difficultyAndTimeDivider)
        RecipeDetailTimeComposition(preparationTime = preparationTime, cookingTime = cookingTime, restingTime = restingTime)

    }
}


@Preview
@Composable
fun RecipeDifficultyAndTimingPreview() {
    Box(
        modifier = Modifier
            .height(100.dp)
            .fillMaxWidth()
            .background(color = Color.White)
    ) {
        RecipeDifficultyAndTiming(
            1, "20 min", 20.toDuration(DurationUnit.MINUTES),
            30.toDuration(DurationUnit.MINUTES),
            80.toDuration(DurationUnit.MINUTES)
        )
    }
}



