package com.miam.kmm_miam_sdk.android.ui.components.recipeDetails

import androidx.compose.animation.core.FastOutLinearInEasing
import androidx.compose.animation.core.animateFloat
import androidx.compose.animation.core.infiniteRepeatable
import androidx.compose.animation.core.rememberInfiniteTransition
import androidx.compose.animation.core.tween
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Card
import androidx.compose.material.Divider
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Brush
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Dimension
import com.miam.kmm_miam_sdk.android.ui.components.recipeDetails.RecipeDetailsStyle

/*
 * Created by Julien Cholin on 30/03/2023
 * Copyright © 2023 Miam. All rights reserved.
 */
@Composable
fun RecipeDetailsLoading() {

    val shimmerColors = listOf(
        Color.LightGray.copy(alpha = 0.6F),
        Color.LightGray.copy(alpha = 0.2F),
        Color.LightGray.copy(alpha = 0.6F)
    )

    val transition = rememberInfiniteTransition()
    val translateAnimation = transition.animateFloat(
        initialValue = 0f,
        targetValue = 1000f,
        animationSpec = infiniteRepeatable(
            animation = tween(
                durationMillis = 1000,
                easing = FastOutLinearInEasing
            )
        )
    )

    val brush = Brush.linearGradient(
        colors = shimmerColors,
        start = Offset.Zero,
        end = Offset(
            x = translateAnimation.value,
            y = translateAnimation.value
        )
    )

    RecipeDetailsLoadingShimmer(brush)
}

@Composable
fun RecipeDetailsLoadingShimmer(brush: Brush) {

    Column(
        modifier = RecipeDetailsStyle.mainColumnsContainer
            .fillMaxHeight()
            .background(Colors.unpureWhite)
    ) {

        // Recipe image
        Box(
            modifier = RecipeDetailsStyle.recipeImageModifier
                .clip(RoundedCornerShape(0))
                .background(brush = brush)
        )

        // Favorite toggle
        Box(
            modifier = Modifier
                .padding(Dimension.lPadding)
                .size(Dimension.mIconHeight)
                .clip(RoundedCornerShape(100))
                .background(brush = brush)
        )

        Divider()

        // Recipe title
        Box(
            modifier = Modifier
                .padding(Dimension.lPadding)
                .fillMaxWidth()
                .height(30.dp)
                .clip(RoundedCornerShape(100))
                .background(brush = brush)
        )

        // Row with level and timing
        Box(
            modifier = Modifier
                .padding(Dimension.lPadding)
                .fillMaxWidth(0.5f)
                .height(48.dp)
                .clip(RoundedCornerShape(100))
                .background(brush = brush)
        )

        // Row with times
        Box(
            modifier = Modifier
                .padding(Dimension.lPadding)
                .fillMaxWidth()
                .height(24.dp)
                .clip(RoundedCornerShape(100))
                .background(brush = brush)
        )

        Spacer(modifier = Modifier.height(45.dp))

        Divider(modifier = Modifier.padding(horizontal = Dimension.mPadding))

        Spacer(modifier = Modifier.height(Dimension.lPadding))

        // Row with ingredients amount and guests amount
        RecipeDetailsLoadingRow(brush, separationWeight = 0.5f)

        Spacer(modifier = Modifier.height(24.dp))

        // Ingredients
        Card(
            modifier = Modifier.padding(horizontal = Dimension.lPadding),
            backgroundColor = Colors.backgroundGrey,
            elevation = 0.dp,
            shape = RoundedCornerShape(topStart = 12.dp, topEnd = 12.dp)
        ) {
            Column(modifier = Modifier.padding(vertical = Dimension.mPadding)) {
                for (i in 0..8) {
                    RecipeDetailsLoadingRow(brush, elementHeight = 16.dp, elementVerticalPadding = Dimension.mPadding, separationWeight = 0.8f)
                }
            }
        }
    }
}

@Composable
private fun RecipeDetailsLoadingRow(
    brush: Brush,
    elementHeight: Dp = 24.dp,
    elementVerticalPadding: Dp = 16.dp,
    separationWeight: Float = 0.2f
) {
    Row(
        Modifier
            .fillMaxWidth()
            .padding(horizontal = Dimension.lPadding),
        horizontalArrangement = Arrangement.SpaceEvenly
    ) {
        Spacer(
            modifier = Modifier
                .padding(vertical = elementVerticalPadding)
                .weight(1f)
                .height(elementHeight)
                .clip(RoundedCornerShape(100))
                .background(brush = brush)
        )
        Spacer(modifier = Modifier.weight(separationWeight))
        Spacer(
            modifier = Modifier
                .padding(vertical = elementVerticalPadding)
                .weight(1f)
                .height(elementHeight)
                .clip(RoundedCornerShape(100))
                .background(brush = brush)
        )
    }
}