package com.miam.sdk.ui.mealPlanner.basketPreview

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Colors.primary
import com.miam.kmm_miam_sdk.android.theme.Typography.bodyBold
import com.miam.sdk.templateInterfaces.mealPlanner.basketPreview.MealPlannerBasketPreviewFooter
import com.miam.sdk.templateParameters.mealPlanner.basketPreview.MealPlannerBasketPreviewFooterParameters

class MealPlannerBasketPreviewFooterImp: MealPlannerBasketPreviewFooter {

    @Composable
    override fun Content(mealPlannerBasketPreviewFooterParameters: MealPlannerBasketPreviewFooterParameters) {
        Column(
            Modifier
                .background(Colors.white)
                .padding(8.dp)
        ) {
            Box(
                Modifier
                    .fillMaxWidth()
                    .border(
                        BorderStroke(1.dp, primary),
                        shape = RoundedCornerShape(8.dp)
                    )
                    .clickable { mealPlannerBasketPreviewFooterParameters.confirmAction() }
            ) {
                Text(
                    modifier = Modifier
                        .padding(8.dp)
                        .fillMaxWidth(),
                    text = "Finaliser",
                    textAlign = TextAlign.Center,
                    color = primary,
                    style = bodyBold
                )
            }
        }
    }
}