package com.miam.sdk.ui.mealPlanner.basketPreview

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.CircularProgressIndicator
import androidx.compose.material.Divider
import androidx.compose.material.IconButton
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import coil.compose.rememberImagePainter
import com.miam.kmm_miam_sdk.android.ressource.Image.delete
import com.miam.kmm_miam_sdk.android.ressource.Image.less
import com.miam.kmm_miam_sdk.android.ressource.Image.plus
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Colors.primary
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.basketPreview.customization.BasketPreviewColor
import com.miam.kmm_miam_sdk.android.ui.components.basketPreview.customization.BasketPreviewImage
import com.miam.kmm_miam_sdk.android.ui.components.basketPreview.customization.BasketPreviewText
import com.miam.kmm_miam_sdk.android.ui.components.basketPreview.subcomponent.MultipleRecipeTag
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable
import com.miam.kmm_miam_sdk.android.ui.components.counter.CounterColor
import com.miam.kmm_miam_sdk.android.ui.components.price.SimplePrice
import com.miam.sdk.templateInterfaces.mealPlanner.basketPreview.MealPlannerBasketPreviewProduct
import com.miam.sdk.templateParameters.mealPlanner.basketPreview.MealPlannerBasketPreviewProductParameters

class MealPlannerBasketPreviewProductImp: MealPlannerBasketPreviewProduct {


    private fun newValueBounded(newValue: Int): Boolean {
        return (newValue > 0) && (newValue <= 100)
    }


    private fun changedValue(localCount: Int?, delta: Int): Int? {

        if (localCount == null) return 0

        if (!newValueBounded(localCount + delta)) return null
        return localCount + delta

    }

    @Composable
    override fun Content(mealPlannerBasketPreviewProductParameters: MealPlannerBasketPreviewProductParameters) {
        Column() {
            Spacer(modifier = Modifier.padding(vertical = 8.dp))
            Row(Modifier.padding(horizontal = 16.dp)) {
                Spacer(modifier = Modifier.padding(vertical = 8.dp))
                Column {
                    Row(
                        modifier = Modifier.fillMaxWidth(),
                        verticalAlignment = Alignment.Top,
                        horizontalArrangement = Arrangement.SpaceBetween
                    ) {
                        Image(
                            painter = rememberImagePainter(mealPlannerBasketPreviewProductParameters.picture),
                            contentDescription = null,
                            contentScale = ContentScale.Crop,
                            modifier = Modifier
                                .height(80.dp)
                                .width(80.dp)
                                .clip(RoundedCornerShape(8.dp))
                        )
                        Spacer(modifier = Modifier.padding(horizontal = 8.dp))
                        Column {
                            Text(
                                text = mealPlannerBasketPreviewProductParameters.name,
                                style = Typography.bodyBold
                            )
                            Spacer(modifier = Modifier.padding(vertical = 2.dp))
                            Text(
                                text = mealPlannerBasketPreviewProductParameters.description,
                                color = BasketPreviewColor.BPPLDescriptionColor,
                                style = Typography.bodySmallBold,
                                modifier = Modifier.widthIn(200.dp, 200.dp)
                            )
                            Spacer(modifier = Modifier.padding(vertical = 2.dp))
                            if (mealPlannerBasketPreviewProductParameters.sharedRecipeCount > 1) {
                                MultipleRecipeTag("Utilisé dans ${mealPlannerBasketPreviewProductParameters.sharedRecipeCount} repas")
                                // TODO use translation
                            }
                        }
                        IconButton(
                            modifier = Modifier.size(30.dp),
                            onClick = { mealPlannerBasketPreviewProductParameters.delete() }
                        ) {
                            Image(
                                painter = painterResource(delete),
                                contentDescription = "delete"
                            )
                        }
                    }

                    Column(Modifier.fillMaxWidth()) {
                        Spacer(modifier = Modifier.padding(vertical = 4.dp))
                        EntryPriceAndActionRow(
                            mealPlannerBasketPreviewProductParameters.id,
                            mealPlannerBasketPreviewProductParameters.isSubstitutable,
                            mealPlannerBasketPreviewProductParameters.isLoading,
                            mealPlannerBasketPreviewProductParameters.quantity,
                            mealPlannerBasketPreviewProductParameters.price,
                            mealPlannerBasketPreviewProductParameters.onQuantityChanged,
                            mealPlannerBasketPreviewProductParameters.changeProduct,
                        )
                        Spacer(modifier = Modifier.padding(vertical = 4.dp))
                        Divider(Modifier.fillMaxWidth(), color = Color.LightGray)
                    }
                }
            }
        }
    }

    @Composable
    fun EntryPriceAndActionRow(
        entryId: String,
        isSubstitutable: Boolean,
        isLoading: Boolean,
        itemsCount: Int,
        price: Double,
        onCounterChanged: (counterValue: Int) -> Unit,
        replace: () -> Unit
    ) {
        Row(
            modifier = Modifier
                .fillMaxWidth(),
            horizontalArrangement = Arrangement.SpaceBetween,
            verticalAlignment = Alignment.CenterVertically
        ) {
            if (isSubstitutable) {
                Clickable(
                    onClick = { replace() },
                    children = {
                        Row(Modifier) {
                            Image(
                                painter = painterResource(BasketPreviewImage.swap),
                                contentDescription = "swap",
                                modifier = Modifier.size(18.dp)
                            )
                            Spacer(modifier = Modifier.padding(horizontal = 2.dp))
                            Text(
                                text = BasketPreviewText.swap,
                                color = Color(0xff037E92),
                                style = Typography.body,
                                modifier = Modifier
                            )
                        }
                    }
                )
            } else {
                Surface {}
            }
            Spacer(
                modifier =
                Modifier.weight(1f)
            )
            Box(modifier = Modifier.padding(end = 16.dp)) {
                SimplePrice(price = price)
            }
            Counter(entryId, itemsCount, isLoading, onCounterChanged)
        }
    }

    @Composable
    private fun Counter(key: String, initialCount: Int, isLoading: Boolean, onCounterChanged: (Int) -> Unit) {

        var localCount by remember(key) { mutableStateOf(initialCount) }

        fun increase() {
            changedValue(localCount, 1)?.let { newCount ->
                localCount = newCount
                onCounterChanged(newCount)
            }
        }

        fun decrease() {
            changedValue(localCount, -1)?.let { newCount ->
                localCount = newCount
                onCounterChanged(newCount)
            }
        }

        Row(
            verticalAlignment = Alignment.CenterVertically,
            modifier = Modifier.border(BorderStroke(1.dp, primary), shape = RoundedCornerShape(50.dp))
        ) {
            CounterButton(less, isLoading) { decrease() }
            CounterText(localCount, isLoading)
            CounterButton(plus, isLoading) { increase() }
        }
    }

    @Composable
    private fun CounterButton(image: Int, isDisable: Boolean, action: () -> Unit) {

        IconButton(
            onClick = { action() },
            enabled = !isDisable,
            modifier = Modifier.background(if (isDisable) Colors.lightgrey else Colors.white)
        ) {
            Image(
                painter = painterResource(image),
                contentDescription = "less icon",
                colorFilter = ColorFilter.tint(primary),
                modifier = Modifier.size(14.dp)
            )

        }
    }

    @Composable
    private fun CounterText(localCount: Int?, isLoading: Boolean) {

        Row(
            modifier = Modifier.width(60.dp),
            verticalAlignment = Alignment.CenterVertically,
            horizontalArrangement = Arrangement.Center,
        ) {
            if (isLoading) {
                CircularProgressIndicator(Modifier.size(20.dp),color = CounterColor.countTextColor)
            } else {
                Text(
                    text = localCount.toString(),
                    color = Colors.black,
                    style = Typography.bodyBold
                )
            }
        }
    }
}