package com.miam.kmm_miam_sdk.android.ui.components.myMeal

import android.content.Context
import android.util.AttributeSet
import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.Button
import androidx.compose.material.CircularProgressIndicator
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.platform.AbstractComposeView
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import com.miam.core.sdk.localisation.Localisation
import com.miam.core.sdk.viewModels.defaultViewModel.basketPreviewViewModel.DefaultBasketPreviewViewModel
import com.miam.kmmMiamCore.component.basketPreview.BasketPreviewViewModel
import com.miam.kmmMiamCore.component.recipe.RecipeViewModel
import com.miam.kmmMiamCore.miam_core.model.BasketPreviewLine
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Colors.white
import com.miam.kmm_miam_sdk.android.theme.Dimension
import com.miam.kmm_miam_sdk.android.theme.Template
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.routerOutlet.RouterOutlet
import com.miam.kmm_miam_sdk.android.ui.components.states.ManagementResourceState


class MyMeal @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {
    private val myMealVm = DefaultBasketPreviewViewModel()
    private val modal = RouterOutlet()

    private var onButtonClickedWhenEmpty: () -> Unit = {}

    fun bind(onButtonClickedWhenEmpty: () -> Unit) {
        this.onButtonClickedWhenEmpty = onButtonClickedWhenEmpty
    }

    @Composable
    override fun Content() {

        val state by myMealVm.uiState.collectAsState()

        ManagementResourceState(
            resourceState = state.lines,
            successView = { previewLines ->
                requireNotNull(previewLines)
                Column(
                    Modifier
                        .fillMaxSize()
                ) {
                    modal.Content()
                    CurrentRecipeInBasket(
                        previewLines,
                        myMealVm
                    ) { modal.goToReplaceItem() }
                }
            },
            loadingView = {
                if (Template.recipeLoaderTemplate != null) {
                    Template.recipeLoaderTemplate?.let { it() }
                } else {
                    MyMealLoading()
                }
            },
            emptyView = {
                MyMealEmpty()
            }
        )
    }

    @Composable
    private fun MyMealLoading() {
        if (Template.myMealLoaderTemplate != null) {
            Template.myMealLoaderTemplate?.let { it() }
        } else {
            Column(
                Modifier.fillMaxSize(),
                verticalArrangement = Arrangement.Center,
                horizontalAlignment = Alignment.CenterHorizontally
            ) {
                CircularProgressIndicator()
            }
        }
    }

    @Composable
    private fun MyMealEmpty() {
        Template.myMealEmptyTemplate?.let {
            it(::onButtonClickedWhenEmpty.invoke())
        } ?: run {
            Column(
                modifier = Modifier
                    .fillMaxSize()
                    .background(white)
                    .padding(Dimension.lPadding),
                verticalArrangement = Arrangement.Center,
                horizontalAlignment = Alignment.CenterHorizontally
            ) {
                Image(
                    painter = painterResource(Image.recipeId),
                    contentDescription = "my meals",
                    modifier = Modifier.size(60.dp),
                    colorFilter = ColorFilter.tint(Colors.primary)
                )

                Spacer(modifier = Modifier.padding(vertical = Dimension.mPadding))

                Text(
                    text = Localisation.MyMeals.noMealIdeaInBasket.localised,
                    textAlign = TextAlign.Center,
                    style = Typography.subtitle
                )

                Spacer(modifier = Modifier.padding(vertical = Dimension.mPadding))

                Button(
                    onClick = {
                        onButtonClickedWhenEmpty()
                    },
                ) {
                    Text(
                        text = Localisation.MyMeals.goToCatalog.localised,
                        style = Typography.button
                    )
                }
            }
        }
    }

    @Composable
    private fun CurrentRecipeInBasket(
        previewLines: List<BasketPreviewLine>,
        myMealVm: DefaultBasketPreviewViewModel,
        goToReplaceItem: () -> Unit
    ) {

        Column(
            Modifier.fillMaxSize(),
            verticalArrangement = Arrangement.Top,
            horizontalAlignment = Alignment.CenterHorizontally
        ) {
            previewLines.forEach { previewLine ->
                val recipeVM = RecipeViewModel(modal.getViewModel())
                val vmBasketPreview = BasketPreviewViewModel(previewLine.id ?: "")

                LaunchedEffect(key1 = recipeVM) {
                    recipeVM.fetchRecipe(previewLine.id ?: "")
                }

                ExpendableBasketPreviewLine(
                    line = previewLine,
                    vmBasketPreview = vmBasketPreview,
                    goToDetail = { recipeVM.goToDetail(false) },
                    removeRecipe = {
                        myMealVm.removeRecipe(
                            previewLines.indexOf(previewLine),
                            previewLines
                        )
                    },
                    goToReplaceItem = {
                        goToReplaceItem()
                    },

                    updateGuest = { recipeVM.updateGuest(it) }
                )
                Spacer(modifier = Modifier.padding(vertical = 8.dp))
            }
        }
    }
}


