package com.miam.sdk.ui.budget.form.expandedForm

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Button
import androidx.compose.material.ButtonDefaults
import androidx.compose.material.CircularProgressIndicator
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import androidx.compose.ui.zIndex
import com.miam.core.sdk.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Dimension
import com.miam.kmm_miam_sdk.android.ui.components.mealPlanner.MealPlannerCounter
import com.miam.sdk.templateInterfaces.budget.form.MealPlannerExpandedForm
import com.miam.sdk.templateParameters.budget.form.MealPlannerFormParameters

internal class MealPlannerExpandedFormImp: MealPlannerExpandedForm {
    @Composable
    override fun Content(mealPlannerFormParameters: MealPlannerFormParameters) {
        Box() {
            Column(
                modifier = Modifier
                    .padding(Dimension.lPadding)
                    .background(Colors.white)
                    .zIndex(1f)
            ) {
                MealPlannerBudget(
                    modifier = Modifier.fillMaxWidth(),
                    caption = Localisation.Budget.totalBudgetTitle.localised,
                    currency = Localisation.Price.currency.localised,
                    budget = mealPlannerFormParameters.budget,
                    onBudgetChange = { mealPlannerFormParameters.setBudget(it) })

                Spacer(modifier = Modifier.height(Dimension.lSpacerHeight))

                Row(
                    Modifier
                        .fillMaxWidth()
                ) {
                    Box(modifier = Modifier.weight(1f)) {
                        MealPlannerCounter(
                            caption = Localisation.Budget.numberOfGuestsTitle.localised,
                            initialCount = mealPlannerFormParameters.numberOfGuests,
                            onCounterChanged = { mealPlannerFormParameters.setNumberOfGuests(it) })
                    }
                    Spacer(modifier = Modifier.width(Dimension.sSpacerHeight))
                    Box(modifier = Modifier.weight(1f)) {
                        MealPlannerCounter(
                            caption = Localisation.Budget.numberOfMealsTitle.localised,
                            initialCount = mealPlannerFormParameters.numberOfMeals,
                            onCounterChanged = { mealPlannerFormParameters.setNumberOfMeals(it) })
                    }
                }

                Spacer(modifier = Modifier.height(Dimension.lSpacerHeight))

                Button(
                    modifier = Modifier
                        .fillMaxWidth()
                        .height(48.dp),
                    onClick = {
                        mealPlannerFormParameters.submit(
                            mealPlannerFormParameters.budget,
                            mealPlannerFormParameters.numberOfMeals,
                            mealPlannerFormParameters.numberOfGuests
                        )
                    },
                    shape = RoundedCornerShape(6.dp),
                    colors = ButtonDefaults.buttonColors(backgroundColor = Colors.primary),
                    enabled = mealPlannerFormParameters.budget.toString().isNotEmpty() && mealPlannerFormParameters.budget >= 2
                ) {
                    Box(modifier = Modifier.fillMaxHeight(), contentAlignment = Alignment.Center) {

                        if (mealPlannerFormParameters.isLoading) {
                            CircularProgressIndicator(
                                modifier = Modifier.size(Dimension.lIconHeight),
                                strokeWidth = 2.dp,
                                color = Colors.white
                            )
                        } else {
                            Text(text = Localisation.Budget.planMealsTitle.localised, color = Colors.white)
                        }
                    }
                }
            }
            AnimatedVisibility(visible = !mealPlannerFormParameters.isFormCollapsed) {
                Box(
                    Modifier
                        .fillMaxSize()
                        .background(Color.White)
                        .zIndex(2f)
                ) {
                }
            }
        }
    }
}