package com.miam.sdk.templatesConfigs.budget


import com.miam.sdk.templatesConfigs.budget.search.BudgetSearchConfig
import com.miam.sdk.templatesConfigs.budget.search.BudgetSearchConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.form.MealPlannerFormConfig
import com.miam.sdk.templatesConfigs.mealPlanner.form.MealPlannerFormConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.planner.empty.MealPlannerEmptyConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.empty.MealPlannerEmptyConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.planner.footer.MealPlannerFooterConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.footer.MealPlannerFooterConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.planner.loading.MealPlannerLoadingConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.loading.MealPlannerLoadingConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.planner.toolbar.MealPlannerToolbarConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.toolbar.MealPlannerToolbarConfigBuilder
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.card.MealPlannerRecipeCardConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.loading.MealPlannerRecipeLoadingConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.placeholder.MealPlannerRecipePlaceholderConfig

class BudgetConfigBuilder {

    var formConfig: MealPlannerFormConfig = MealPlannerFormConfig()
    var plannerEmptyConfig: MealPlannerEmptyConfig = MealPlannerEmptyConfig()
    var plannerFooterConfig: MealPlannerFooterConfig = MealPlannerFooterConfig()
    var plannerLoadingConfig: MealPlannerLoadingConfig = MealPlannerLoadingConfig()
    var plannerToolbarConfig: MealPlannerToolbarConfig = MealPlannerToolbarConfig()
    var recipeCardConfig: MealPlannerRecipeCardConfig = MealPlannerRecipeCardConfig()
    var recipePlaceholderConfig: MealPlannerRecipePlaceholderConfig = MealPlannerRecipePlaceholderConfig()
    var recipeLoadingConfig: MealPlannerRecipeLoadingConfig = MealPlannerRecipeLoadingConfig()
    var searchConfig: BudgetSearchConfig = BudgetSearchConfig()


    inline fun formConfig(init: MealPlannerFormConfigBuilder.() -> Unit) {
        this.formConfig = MealPlannerFormConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun plannerEmptyConfig(init: MealPlannerEmptyConfigBuilder.() -> Unit) {
        this.plannerEmptyConfig = MealPlannerEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun plannerFooterConfig(init: MealPlannerFooterConfigBuilder.() -> Unit) {
        this.plannerFooterConfig = MealPlannerFooterConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun plannerLoadingConfig(init: MealPlannerLoadingConfigBuilder.() -> Unit) {
        this.plannerLoadingConfig = MealPlannerLoadingConfigBuilder()
            .apply(init)
            .build()
    }


    inline fun plannerToolbarConfig(init: MealPlannerToolbarConfigBuilder.() -> Unit) {
        this.plannerToolbarConfig = MealPlannerToolbarConfigBuilder()
            .apply(init)
            .build()
    }


    inline fun searchConfig(init: BudgetSearchConfigBuilder.() -> Unit) {
        this.searchConfig = BudgetSearchConfigBuilder()
            .apply(init)
            .build()
    }


    @PublishedApi
    internal fun build(): BudgetConfig {
        return BudgetConfig(
            formConfig,
            plannerEmptyConfig,
            plannerFooterConfig,
            plannerLoadingConfig,
            plannerToolbarConfig,
            recipeCardConfig,
            recipePlaceholderConfig,
            recipeLoadingConfig,
            searchConfig,
        )
    }
}

