package com.miam.sdk.di

import com.miam.sdk.templatesConfigs.TemplatesConfigs
import com.miam.sdk.templatesConfigs.budget.BudgetConfig
import com.miam.sdk.templatesConfigs.budget.search.BudgetSearchConfig
import com.miam.sdk.templatesConfigs.mealPlanner.MealPlannerConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.empty.MealPlannerBasketPreviewEmptyConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.footer.MealPlannerBasketPreviewFooterConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.loading.MealPlannerBasketPreviewLoadingConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.product.MealPlannerBasketPreviewProductConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.recipeOverview.MealPlannerBasketPreviewRecipeOverviewConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.sectionProduct.MealPlannerBasketPreviewSectionProductConfig
import com.miam.sdk.templatesConfigs.mealPlanner.basketPreview.sectionTitle.MealPlannerBasketPreviewSectionTitleConfig
import com.miam.sdk.templatesConfigs.mealPlanner.callToAction.MealPlannerCallToActionConfig
import com.miam.sdk.templatesConfigs.mealPlanner.form.MealPlannerFormConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.empty.MealPlannerEmptyConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.footer.MealPlannerFooterConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.loading.MealPlannerLoadingConfig
import com.miam.sdk.templatesConfigs.mealPlanner.planner.toolbar.MealPlannerToolbarConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recap.MealPlannerRecapConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.card.MealPlannerRecipeCardConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.loading.MealPlannerRecipeLoadingConfig
import com.miam.sdk.templatesConfigs.mealPlanner.recipe.placeholder.MealPlannerRecipePlaceholderConfig
import com.miam.sdk.templatesConfigs.mealPlanner.search.MealPlannerSearchEmptyConfig

object TemplateDI {

    internal val templates: TemplatesConfigs by lazy { TemplatesConfigs.getInstance() }

    /** BUDGET  */
    internal val budget: BudgetConfig by lazy { templates.budget }
    internal val mealPlanner: MealPlannerConfig by lazy { templates.mealPlanner }

    //FORM
    internal val mealPlannerForm: MealPlannerFormConfig by lazy { mealPlanner.form }

    //Call To Action
    internal val mealPlannerCallToActionButton: MealPlannerCallToActionConfig by lazy { mealPlanner.callToAction }

    // PLANNER
    internal val plannerEmpty: MealPlannerEmptyConfig by lazy { budget.plannerEmpty }
    internal val plannerFooter: MealPlannerFooterConfig by lazy { budget.plannerFooter }
    internal val plannerLoading: MealPlannerLoadingConfig by lazy { budget.plannerLoading }
    internal val mealPlannerToolbar: MealPlannerToolbarConfig by lazy { budget.plannerToolbar }

    // RECIPE
    internal val mealPlannerRecipeCard: MealPlannerRecipeCardConfig by lazy { mealPlanner.recipeCard }
    internal val mealPlannerRecipePlaceholder: MealPlannerRecipePlaceholderConfig by lazy { mealPlanner.recipePlaceholder }
    internal val mealPlannerRecipeLoading: MealPlannerRecipeLoadingConfig by lazy { mealPlanner.recipeLoading }

    // BASKET PREVIEW
    internal val mealPlannerBasketPreviewEmpty: MealPlannerBasketPreviewEmptyConfig by lazy { mealPlanner.basketPreviewEmpty }
    internal val mealPlannerBasketPreviewLoading: MealPlannerBasketPreviewLoadingConfig by lazy { mealPlanner.basketPreviewLoading }
    internal val mealPlannerBasketPreviewProduct: MealPlannerBasketPreviewProductConfig by lazy { mealPlanner.basketPreviewProduct }
    internal val mealPlannerBasketPreviewFooter: MealPlannerBasketPreviewFooterConfig by lazy { mealPlanner.basketPreviewFooter }
    internal val mealPlannerBasketPreviewRecipeOverview: MealPlannerBasketPreviewRecipeOverviewConfig by lazy { mealPlanner.basketPreviewRecipeOverview }
    internal val mealPlannerBasketPreviewSectionProduct: MealPlannerBasketPreviewSectionProductConfig by lazy { mealPlanner.basketPreviewSectionProduct }
    internal val mealPlannerBasketPreviewSectionTitle: MealPlannerBasketPreviewSectionTitleConfig by lazy { mealPlanner.basketPreviewSectionTitle }

    // SEARCH
    internal val budgetSearch: BudgetSearchConfig by lazy { budget.search }
    internal val searchEmpty: MealPlannerSearchEmptyConfig by lazy { mealPlanner.searchEmpty }


    //RECAP
    internal val mealPlannerRecap: MealPlannerRecapConfig by lazy { mealPlanner.recap }
}