package com.miam.sdk.ui.mealPlanner.recipe

import androidx.compose.foundation.Canvas
import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.graphics.PathEffect
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.miam.core.sdk.localisation.Localisation
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Colors.primary
import com.miam.kmm_miam_sdk.android.theme.Dimension
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.sdk.templateInterfaces.mealPlanner.recipe.MealPlannerRecipePlaceholder
import com.miam.sdk.templateParameters.mealPlanner.recipe.MealPlannerRecipePlaceholderParameters

class MealPlannerRecipePlaceholderImp: MealPlannerRecipePlaceholder {

    @Composable
    override fun Content(mealPlannerRecipePlaceholderParameters: MealPlannerRecipePlaceholderParameters) {
        Box(
            modifier = Modifier
                .height(Dimension.mealPlannerCardHeight)
                .padding(vertical = Dimension.mPadding)
                .background(color = Color.White)
        ) {
            Canvas(modifier = Modifier.matchParentSize()) {
                val strokeWidthPx = Dimension.borderWidth.toPx()
                val yTop = strokeWidthPx / 2
                val yBottom = size.height - strokeWidthPx / 2
                val pathEffect = PathEffect.dashPathEffect(floatArrayOf(10f, 10f), 0f)

                drawLine(
                    color = primary,
                    start = Offset(0f, yTop),
                    end = Offset(size.width, yTop),
                    pathEffect = pathEffect,
                    strokeWidth = strokeWidthPx
                )
                drawLine(
                    color = primary,
                    start = Offset(0f, yBottom),
                    end = Offset(size.width, yBottom),
                    pathEffect = pathEffect,
                    strokeWidth = strokeWidthPx
                )
            }
            Column(
                modifier = Modifier.fillMaxSize(),
                verticalArrangement = Arrangement.Center,
                horizontalAlignment = Alignment.CenterHorizontally,
            ) {

                Box(
                    modifier = Modifier
                        .size(48.dp)
                        .clip(RoundedCornerShape(4.dp))
                        .background(Colors.primary).clickable {
                            mealPlannerRecipePlaceholderParameters.action()
                        },
                    contentAlignment = Alignment.Center
                ) {
                    Image(
                        painter = painterResource(id = Image.plus),
                        colorFilter = ColorFilter.tint(Color.White),
                        contentDescription = "Plus",
                        modifier = Modifier.size(16.dp)
                    )
                }

                Text(
                    Localisation.Budget.addMealIdea.localised,
                    style = Typography.bodyBold,
                    color = Colors.primary,
                    textAlign = TextAlign.Center,
                    modifier = Modifier.padding(top = Dimension.mPadding)
                )

            }
        }
    }

    @Preview
    @Composable
    fun MealPlannerRecipePlaceholderImpPreview() {
        MealPlannerRecipePlaceholderImp().Content(mealPlannerRecipePlaceholderParameters = MealPlannerRecipePlaceholderParameters { print("hello") })
    }
}
