package com.miam.kmm_miam_sdk.android.ui.components.mealPlanner

import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.IconButton
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.miam.core.sdk.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors.black
import com.miam.kmm_miam_sdk.android.theme.Colors.primary
import com.miam.kmm_miam_sdk.android.theme.Colors.white
import com.miam.kmm_miam_sdk.android.theme.Dimension
import com.miam.kmm_miam_sdk.android.ui.components.counter.CounterImage.less
import com.miam.kmm_miam_sdk.android.ui.components.counter.CounterImage.plus
import com.miam.kmm_miam_sdk.android.ui.components.counter.CounterStyle.plusButtonIcon


@Composable
fun MealPlannerCounter(
    caption: String,
    initialCount: Int = 1,
    onCounterChanged: (newValue: Int) -> Unit,
    minValue: Int = 1,
    maxValue: Int = 9,
    key: Any? = null
) {
    var localCount by remember(key ?: initialCount) { mutableStateOf(initialCount) }

    fun decrease() {
        if (localCount == minValue) {
            onCounterChanged(localCount)
            return
        }
        localCount--
        onCounterChanged(localCount)
    }

    fun increase() {
        if (localCount == maxValue) {
            onCounterChanged(localCount)
            return
        }
        localCount++
        onCounterChanged(localCount)
    }

    Column {
        Text(
            text = caption,
            style = TextStyle(color = black, fontSize = 14.sp, fontWeight = FontWeight.W700)
        )
        Spacer(modifier = Modifier.height(4.dp))
        Row(
            modifier = Modifier
                .fillMaxWidth()
                .height(48.dp)
                .border(
                    width = 1.dp,
                    color = primary,
                    shape = RoundedCornerShape(6.dp)
                ),
            verticalAlignment = Alignment.CenterVertically,
            horizontalArrangement = Arrangement.SpaceBetween
        ) {
            Minus(localCount > 1) { decrease() }
            MiddleText(localCount)
            Plus(localCount < 9) { increase() }
        }
    }
}

@Composable
fun Minus(enabled: Boolean, decrease: () -> Unit) {
    IconButton(
        onClick = { decrease() },
        enabled = enabled
    ){
        Image(
            painter = painterResource(less),
            contentDescription = "minus icon",
            colorFilter = ColorFilter.tint(primary),
            modifier = Modifier.size(Dimension.mIconHeight)
         )
    }
}


@Composable
fun MiddleText(localCount: Int?) {
    fun counterText(countValue: Int?): String {
        if (countValue == null) return "-"
        return localCount.toString()
    }

    Row(
        verticalAlignment = Alignment.CenterVertically,
        horizontalArrangement = Arrangement.Center,
    ) {
        Text(
            text = counterText(localCount),
            style = TextStyle(color = black, fontSize = 16.sp, fontWeight = FontWeight.W900)
        )
    }
}

@Composable
fun Plus(enabled: Boolean, increase: () -> Unit) {
    IconButton(
        onClick = { increase() },
        enabled = enabled
    ) {
        Image(
            painter = painterResource(plus),
            contentDescription = "plus icon",
            colorFilter = ColorFilter.tint(primary),
            modifier = plusButtonIcon
        )
    }
}

@Preview
@Composable
fun MealPlannerCounterPreview() {
    Box(modifier = Modifier.background(white)) {
        MealPlannerCounter(caption = Localisation.Budget.numberOfMealsTitle.localised, 4, {})
    }
}