package com.miam.sdk.ui.mealPlanner.basketPreview

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.miam.core.sdk.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.basketPreview.customization.BasketPreviewImage.add
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable
import com.miam.kmm_miam_sdk.android.ui.components.price.PriceShimmer
import com.miam.sdk.templateInterfaces.mealPlanner.basketPreview.MealPlannerBasketPreviewSectionProduct
import com.miam.sdk.templateParameters.mealPlanner.basketPreview.MealPlannerBasketPreviewSectionProductParameters

class MealPlannerBasketPreviewSectionProductImp: MealPlannerBasketPreviewSectionProduct {

    @Composable
    override fun Content(mealPlannerBasketPreviewSectionProductParameters: MealPlannerBasketPreviewSectionProductParameters) {
        Row(
            verticalAlignment = Alignment.CenterVertically,
            horizontalArrangement = Arrangement.SpaceBetween,
            modifier = Modifier
                .padding(vertical = 16.dp, horizontal = 32.dp)
                .fillMaxWidth()

        ) {
            Text(
                text = mealPlannerBasketPreviewSectionProductParameters.name,
                style = Typography.body
            )
            if (mealPlannerBasketPreviewSectionProductParameters.canBeAdd) {
                Clickable(
                    onClick = { mealPlannerBasketPreviewSectionProductParameters.add() },
                    children = {
                        Row(verticalAlignment = Alignment.CenterVertically) {
                            Image(
                                painter = painterResource(add),
                                contentDescription = null,
                                modifier = Modifier.size(14.dp)
                            )
                            Spacer(modifier = Modifier.padding(8.dp))
                            Text(
                                text = Localisation.Basket.addProduct.localised,
                                style = Typography.bodyBold,
                            )
                        }
                    }
                )
            }
        }
    }

    @Preview
    @Composable
    fun canBeAddContent() {
        Content( MealPlannerBasketPreviewSectionProductParameters(
            "Poire",
            true,
            {}
        ))
    }

    @Preview
    @Composable
    fun cantBeAddContent() {
        Content( MealPlannerBasketPreviewSectionProductParameters(
            "Poire",
            false,
            {}
        ))
    }
}