package com.miam.sdk.templateParameters.mealPlanner.form

import com.miam.core.sdk.base.state.ComponentUiState
import kotlinx.coroutines.flow.Flow

data class MealPlannerFormParameters(
    val budget: Int,
    val numberOfGuests: Int,
    val numberOfMeals: Int,
    val uiState: ComponentUiState,
    val setBudget: (Int) -> Unit,
    val setNumberOfGuests: (Int) -> Unit,
    val setNumberOfMeals: (Int) -> Unit,
    val maxMealCount: Int,
    val currentRemainingRecipeCountFlow: Flow<Int>,
    val refreshMaxMealCount: (budget: Int, guestCount: Int) -> Unit,
    val submit: (budget: Int, numberOfGuests: Int, numberOfMeal: Int) -> Unit
)
