package com.miam.sdk.components.mealPlanner.recap

import android.content.Context
import android.util.AttributeSet
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.platform.AbstractComposeView
import com.miam.core.sdk.viewModels.mealPlanner.recap.MealPlannerRecapViewModel
import com.miam.sdk.di.TemplateDI
import com.miam.sdk.templateParameters.mealPlanner.recap.MealPlannerRecapParameters

class MealPlannerRecap @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    private val recapVM = MealPlannerRecapViewModel()

    var action: () -> Unit = {}

    @Composable
    override fun Content() {
        val state = recapVM.uiState.collectAsState()

        TemplateDI.mealPlannerRecap.view.Content(
            mealPlannerRecapParameters =
            MealPlannerRecapParameters(
                state.value.numberOfMeals,
                state.value.totalPrice,
            ) { action() }
        )
    }
}
