package com.miam.sdk.ui.mealPlanner.recipe.search

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.sdk.templateInterfaces.mealPlanner.search.MealPlannerSearchEmpty
import com.miam.sdk.templateParameters.mealPlanner.search.MealPlannerSearchEmptyParameters

class MealPlannerSearchEmptyImp: MealPlannerSearchEmpty {
    @Composable
    override fun Content(mealPlannerSearchEmptyParameters: MealPlannerSearchEmptyParameters) {
        Column(
            Modifier.padding(16.dp),
            horizontalAlignment = Alignment.CenterHorizontally
        ) {
            Text(
                text = "Aucun résultats de recherche",
                style = Typography.bodyBold,
                modifier = Modifier.fillMaxWidth()
            )
            Spacer(modifier = Modifier.height(8.dp))
            Image(
                painter = painterResource(Image.miamEmpty),
                contentDescription = null,
                modifier = Modifier.height(250.dp)
            )
            Spacer(modifier = Modifier.height(8.dp))
            Text(
                text = "Désolé, nous n’avons trouvé aucune idée repas.\n" +
                        "Essayez avec une autre recherche.",
                color = Colors.grey,
                style = Typography.bodySmall
            )
        }
    }
}