package com.miam.sdk.ui.mealPlanner.recap

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Divider
import androidx.compose.material.Icon
import androidx.compose.material.Text
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.CheckCircle
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Colors.black
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.price.formatPrice
import com.miam.sdk.templateInterfaces.mealPlanner.recap.MealPlannerRecap
import com.miam.sdk.templateParameters.mealPlanner.recap.MealPlannerRecapParameters

class MealPlannerRecapImp: MealPlannerRecap {

    //TODO  ADD TRANSLATION
    @Composable
    override fun Content(mealPlannerRecapParameters: MealPlannerRecapParameters) {
        Column(
            Modifier
                .fillMaxSize()
                .padding(horizontal = 16.dp),
            verticalArrangement = Arrangement.Top,
            horizontalAlignment = Alignment.CenterHorizontally

        ) {
            Spacer(modifier = Modifier.height(24.dp))
            Row(
                Modifier
                    .background(color = Colors.miamSuccessBackGround, shape = RoundedCornerShape(8.dp))
                    .fillMaxWidth(),
                horizontalArrangement = Arrangement.Center,
                verticalAlignment = Alignment.CenterVertically
            ) {
                Icon(
                    Icons.Default.CheckCircle,
                    contentDescription = "",
                    tint = Colors.positive,
                    modifier = Modifier
                        .padding(20.dp)
                        .size(20.dp)
                )
            }
            Spacer(modifier = Modifier.height(24.dp))
            Text(
                text = "Les produits associés ont bien été ajoutés au panier.",
                modifier = Modifier.fillMaxWidth(),
                style = Typography.subtitleBold,
                textAlign = TextAlign.Center,
                color = black
            )
            Spacer(modifier = Modifier.height(24.dp))
            Row(
                verticalAlignment = Alignment.CenterVertically,
                horizontalArrangement = Arrangement.SpaceBetween,
                modifier = Modifier
                    .fillMaxWidth()
                    .padding(8.dp)
                    .border(
                        BorderStroke(1.dp, Colors.grey),
                        shape = RoundedCornerShape(8.dp)
                    )
            ) {
                Text(
                    text = "${mealPlannerRecapParameters.numberOfMeals} repas pour",
                    style = Typography.body,
                    modifier = Modifier.padding(8.dp)
                )
                Text(
                    text = "${formatPrice(mealPlannerRecapParameters.totalPrice)}",
                    style = Typography.subtitleBold,
                    color = Colors.primary,
                    modifier = Modifier.padding(8.dp)
                )
            }
            Spacer(modifier = Modifier.height(24.dp))
            Divider()
            Spacer(modifier = Modifier.height(24.dp))
            Text(
                text = "Découvrez aussi",
                modifier = Modifier.fillMaxWidth(),
                style = Typography.subtitleBold,
                textAlign = TextAlign.Center,
                color = black
            )
            Spacer(modifier = Modifier.height(24.dp))
            Box(
                Modifier
                    .background(color = Colors.primary, shape = RoundedCornerShape(8.dp))
                    .padding(8.dp)
                    .fillMaxWidth()
                    .clickable {
                        mealPlannerRecapParameters.action()
                    }
            ) {
                Text(
                    text = "Nos promotions",
                    modifier = Modifier
                        .padding(8.dp)
                        .fillMaxWidth(),
                    color = Colors.white,
                    style = Typography.bodyBold,
                    textAlign = TextAlign.Center
                )
            }
        }
    }
}