package com.miam.sdk.ui.mealPlanner.form

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Button
import androidx.compose.material.ButtonDefaults
import androidx.compose.material.CircularProgressIndicator
import androidx.compose.material.Icon
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import androidx.compose.ui.zIndex
import com.miam.core.sdk.base.state.ComponentUiState
import com.miam.core.sdk.localisation.Localisation
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Dimension
import com.miam.kmm_miam_sdk.android.ui.components.mealPlanner.MealPlannerCounter
import com.miam.sdk.templateInterfaces.mealPlanner.form.MealPlannerForm
import com.miam.sdk.templateParameters.mealPlanner.form.MealPlannerFormParameters
import com.miam.sdk.ui.mealPlanner.planner.toolbar.MealPlannerBudget


internal class MealPlannerFormImp: MealPlannerForm {
    @Composable
    override fun Content(mealPlannerFormParameters: MealPlannerFormParameters) {

        Column(
            modifier = Modifier
                .padding(Dimension.lPadding)
                .background(Colors.white)
                .zIndex(1f)
        ) {
            MealPlannerBudget(
                modifier = Modifier.fillMaxWidth(),
                caption = Localisation.Budget.totalBudgetTitle.localised,
                currency = Localisation.Price.currency.localised,
                budget = mealPlannerFormParameters.budget,
                onBudgetChange = {
                    mealPlannerFormParameters.setBudget(it)
                })

            Spacer(modifier = Modifier.height(Dimension.lSpacerHeight))

            Row(
                Modifier
                    .fillMaxWidth()
            ) {
                Box(modifier = Modifier.weight(1f)) {
                    MealPlannerCounter(
                        caption = Localisation.Budget.numberOfGuestsTitle.localised,
                        initialCount = mealPlannerFormParameters.numberOfGuests,
                        onCounterChanged = { mealPlannerFormParameters.setNumberOfGuests(it) })
                }
                Spacer(modifier = Modifier.width(Dimension.sSpacerHeight))
                Box(modifier = Modifier.weight(1f)) {
                    MealPlannerCounter(
                        caption = Localisation.Budget.numberOfMealsTitle.localised,
                        initialCount = mealPlannerFormParameters.numberOfMeals,
                        onCounterChanged = { mealPlannerFormParameters.setNumberOfMeals(it) })
                }
            }

            Spacer(modifier = Modifier.height(Dimension.lSpacerHeight))

            Button(
                modifier = Modifier
                    .fillMaxWidth()
                    .height(48.dp),
                onClick = {
                    mealPlannerFormParameters.submit(
                        mealPlannerFormParameters.budget,
                        mealPlannerFormParameters.numberOfMeals,
                        mealPlannerFormParameters.numberOfGuests
                    )
                },
                shape = RoundedCornerShape(6.dp),
                colors = ButtonDefaults.buttonColors(backgroundColor = Colors.primary),
                enabled = mealPlannerFormParameters.budget.toString().isNotEmpty() && mealPlannerFormParameters.uiState != ComponentUiState.EMPTY
            ) {
                Box(modifier = Modifier.fillMaxHeight(), contentAlignment = Alignment.Center) {
                    if (mealPlannerFormParameters.uiState == ComponentUiState.LOADING) {
                        CircularProgressIndicator(
                            modifier = Modifier.size(Dimension.lIconHeight),
                            strokeWidth = 2.dp,
                            color = Colors.white
                        )
                    } else {
                        Text(text = "Planifier", color = Colors.white)
                    }
                }
            }
            Spacer(modifier = Modifier.height(32.dp))
            AnimatedVisibility(mealPlannerFormParameters.uiState == ComponentUiState.EMPTY) {
                Box(modifier = Modifier.background(Colors.miamDangerBackground, RoundedCornerShape(8.dp))) {
                    Column(
                        Modifier.padding(16.dp)
                    ) {
                        Icon(
                            painter = painterResource(id = Image.alert),
                            contentDescription = "",
                            tint = Colors.dangerBudgetText
                        )
                        Spacer(modifier = Modifier.height(8.dp))
                        Text(
                            text = "Aucune idée repas n’a pu être planifiée pour le budget demandé.",
                            color = Colors.dangerBudgetText
                        )
                    }
                }
            }
        }
    }
}
