package com.miam.sdk.ui.mealPlanner.basketPreview

import androidx.compose.animation.core.animateFloatAsState
import androidx.compose.foundation.Image
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.Divider
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.rotate
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.ressource.Image.toggleCaret
import com.miam.sdk.templateInterfaces.mealPlanner.basketPreview.MealPlannerBasketPreviewSectionTitle
import com.miam.sdk.templateParameters.mealPlanner.basketPreview.MealPlannerBasketPreviewSectionTitleParameters

class MealPlannerBasketPreviewSectionTitleImp: MealPlannerBasketPreviewSectionTitle {
    @Composable
    override fun Content(mealPlannerBasketPreviewSectionTitleParameters: MealPlannerBasketPreviewSectionTitleParameters) {
        var expandedState by remember { mutableStateOf(mealPlannerBasketPreviewSectionTitleParameters.isCollapse) }
        val rotationState by animateFloatAsState(
            targetValue = if (expandedState) 90f else 0f
        )

        fun toggle() {
            expandedState = !expandedState
        }

        Box(
            modifier = Modifier
                .padding(horizontal = 16.dp)
                .clickable {
                    mealPlannerBasketPreviewSectionTitleParameters.toggleCollapse()
                    toggle()
                }
        ) {
            Column {
                Row(
                    verticalAlignment = Alignment.CenterVertically,
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(start = 16.dp)
                        .padding(vertical = 16.dp)
                ) {
                    Text(
                        modifier = Modifier
                            .weight(6f),
                        text = mealPlannerBasketPreviewSectionTitleParameters.title,
                        fontWeight = if (expandedState) FontWeight.Bold else FontWeight.Normal
                    )

                    Image(
                        painter = painterResource(toggleCaret),
                        contentDescription = null,
                        modifier = Modifier
                            .size(24.dp)
                            .weight(1f)
                            .rotate(rotationState)
                    )
                }
                if (!expandedState) {
                    Divider()
                }
            }
        }
    }

    @Preview
    @Composable
    fun MealPlannerSectionTitleContentPreview() {
        Content(MealPlannerBasketPreviewSectionTitleParameters(
            "Produit indisponible",
            false,
            {}
        ))
    }

}