package com.miam.sdk.ui.mealPlanner.basketPreview

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material.CircularProgressIndicator
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.miam.core.sdk.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.sdk.templateInterfaces.mealPlanner.basketPreview.MealPlannerBasketPreviewLoading
import com.miam.sdk.templateParameters.mealPlanner.basketPreview.MealPlannerBasketPreviewLoadingParameters

class MealPlannerBasketPreviewLoadingImp: MealPlannerBasketPreviewLoading {
    @Composable
    override fun Content(mealPlannerBasketPreviewLoadingParameters: MealPlannerBasketPreviewLoadingParameters) {
        Column(
            Modifier.fillMaxSize(),
            horizontalAlignment = Alignment.CenterHorizontally,
            verticalArrangement = Arrangement.Center
        ) {
            Text(Localisation.Catalog.loadingText.localised, style = Typography.subtitleBold, modifier = Modifier.padding(8.dp))
            CircularProgressIndicator(color = Colors.primary)
        }
    }
}