package com.miam.sdk.components.mealPlanner


import android.content.Context
import android.util.AttributeSet
import androidx.compose.foundation.layout.Box
import androidx.compose.runtime.Composable
import com.miam.kmmMiamCore.miam_core.model.Recipe
import com.miam.sdk.components.baseComponent.recipeCard.BaseRecipeCard
import com.miam.sdk.di.TemplateDI
import com.miam.sdk.templateParameters.mealPlanner.recipe.MealPlannerRecipeCardParameters
import com.miam.sdk.templateParameters.mealPlanner.recipe.MealPlannerRecipeLoadingParameters

class MealPlannerRecipeCard @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): BaseRecipeCard(context, attrs, defStyleAttr) {

    internal var index: Int = 0
        set(value) {
            field = value
        }
    internal var isInSearchPage = false
        set(value) {
            field = value
        }
    internal var price: Double = 0.0
       
    internal var changeAction = {}
        set(value) {
            field = value
        }

    internal var replaceAction = { }
        set(value) {
            field = value
        }
    internal var deleteAction = {}
        set(value) {
            field = value
        }

    @Composable
    override fun SuccessView(recipe: Recipe) {
        TemplateDI.mealPlannerRecipeCard.view.Content(
            mealPlannerRecipeCardParameters = MealPlannerRecipeCardParameters(
                index = index,
                isInSearchPage = isInSearchPage,
                isAlreadyInBasket = vmRecipe.currentState.isInCart,
                price = price,
                recipe = recipe,
                changeAction = changeAction,
                replaceAction = replaceAction,
                deleteAction = deleteAction,
                openDetail = { vmRecipe.goToDetail(false) }
            )
        )
    }

    @Composable
    override fun LoadingView() {
        TemplateDI.mealPlannerRecipeLoading.view.Content(
            mealPlannerRecipeLoadingParameters = MealPlannerRecipeLoadingParameters()
        )
    }

    @Composable
    override fun EmptyView() {
        Box {}
    }
}