package com.miam.sdk.components.baseComponent.recipeCard

import android.content.Context
import android.util.AttributeSet
import androidx.compose.animation.Crossfade
import androidx.compose.animation.core.tween
import androidx.compose.foundation.layout.Column
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.platform.AbstractComposeView
import com.miam.kmmMiamCore.component.recipe.RecipeViewModel
import com.miam.kmmMiamCore.miam_core.model.Recipe
import com.miam.kmm_miam_sdk.android.ui.components.routerOutlet.RouterOutlet
import com.miam.kmm_miam_sdk.android.ui.components.states.ManagementResourceState

abstract class BaseRecipeCard @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    internal val modal = RouterOutlet()
    internal val vmRecipe: RecipeViewModel = RecipeViewModel(modal.getViewModel())
    internal var idRecipeState: String? = null


    var idRecipe: String
        get() = idRecipeState ?: ""
        set(value) {
            idRecipeState = value
            vmRecipe.fetchRecipe(idRecipe)
        }

    var recipe: Recipe? = null
        set(value) {
            field = value
            recipe?.let { vmRecipe.setRecipe(it) }
        }

    @Composable
    override fun Content() {
        Column {
            modal.Content()
            UpdatableContent()
        }
    }

    @Composable
    private fun UpdatableContent() {
        val state by vmRecipe.uiState.collectAsState()

        Crossfade(targetState = state.recipeState, animationSpec = tween(750,0)) { recipeState ->
            ManagementResourceState(
                resourceState = recipeState,
                successView = { recipe ->
                    requireNotNull(recipe)
                    SuccessView(recipe = recipe)
                },
                loadingView = {
                    LoadingView()
                },
                emptyView = {
                    EmptyView()
                }
            )
        }
    }

    @Composable
    abstract fun SuccessView(recipe: Recipe)

    @Composable
    abstract fun LoadingView()

    @Composable
    abstract fun EmptyView()

}
