/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.ext.interchan.redis.commands;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.RedisTemplate;
import tech.mhuang.core.util.CollectionUtil;
import tech.mhuang.core.util.StringUtil;
import tech.mhuang.ext.interchan.redis.commands.AbstractBaseRedisCommands;
import tech.mhuang.ext.interchan.redis.commands.RedisCommand;

public class RedisExtCommands
extends AbstractBaseRedisCommands {
    public void setRedisTemplate(RedisTemplate<String, ?> redisTemplate) {
        this.baseTempalte = redisTemplate;
    }

    @Override
    public boolean hset(String key, String field, Object value, long seconds) {
        boolean result = this.hset(key, field, value);
        if (result) {
            result = this.expire(key, seconds);
        }
        return result;
    }

    @Override
    public <T> T hget(String key, String field, Class<T> clazz) {
        return this.hget(this.defaultDbIndex, key, field, clazz);
    }

    @Override
    public <T> T hget(int dbIndex, String key, String field, Class<T> clazz) {
        String value = this.hget(dbIndex, key, field);
        if (StringUtil.isEmpty((CharSequence)value)) {
            return null;
        }
        return (T)JSON.parseObject((String)value, clazz);
    }

    @Override
    public <T> List<T> hgetList(String key, String field, Class<T> clazz) {
        return this.hgetList(this.defaultDbIndex, key, field, clazz);
    }

    @Override
    public <T> List<T> hgetList(int dbIndex, String key, String field, Class<T> clazz) {
        String value = this.hget(dbIndex, key, field);
        if (StringUtil.isEmpty((CharSequence)value)) {
            return null;
        }
        return JSON.parseArray((String)value, clazz);
    }

    @Override
    public <T> List<T> hvals(int index, String key, Class<T> clazz) {
        List<String> value = this.hvals(index, key);
        if (CollectionUtil.isEmpty(value)) {
            return null;
        }
        return value.parallelStream().map(val -> JSON.parseObject((String)val, (Class)clazz)).collect(Collectors.toList());
    }

    @Override
    public <T> Map<String, T> hgetAll(int index, String key, Class<T> clazz) {
        Map<String, String> map = this.hgetall(index, key);
        HashMap result = new HashMap(map.size());
        map.forEach((mapKey, mapValue) -> result.put(mapKey, JSON.parseObject((String)mapValue, (Class)clazz)));
        return result;
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        String value = this.get(key);
        if (StringUtil.isEmpty((CharSequence)value)) {
            return null;
        }
        return (T)JSON.parseObject((String)value, clazz);
    }

    @Override
    public <T> T get(int dbIndex, String key, Class<T> clazz) {
        String value = this.get(dbIndex, key);
        if (StringUtil.isEmpty((CharSequence)value)) {
            return null;
        }
        return (T)JSON.parseObject((String)value, clazz);
    }

    @Override
    public <T> Map<String, T> hgetAll(String key, Class<T> clazz) {
        Map<String, String> map = this.hgetall(key);
        HashMap result = new HashMap(map.size());
        map.forEach((mapKey, mapValue) -> result.put(mapKey, JSON.parseObject((String)mapValue, (Class)clazz)));
        return result;
    }

    @Override
    public <T> Map<String, List<T>> hgetAllList(String key, Class<T> clazz) {
        Map<String, String> map = this.hgetall(key);
        HashMap result = new HashMap(map.size());
        map.forEach((mapKey, mapValue) -> result.put((String)mapKey, JSON.parseArray((String)mapValue, (Class)clazz)));
        return result;
    }

    @Override
    public <T> Map<String, List<T>> hgetAllList(int index, String key, Class<T> clazz) {
        Map<String, String> map = this.hgetall(index, key);
        HashMap result = new HashMap(map.size());
        map.forEach((mapKey, mapValue) -> result.put((String)mapKey, JSON.parseArray((String)mapValue, (Class)clazz)));
        return result;
    }

    @Override
    public <T> List<T> hvals(String key, Class<T> clazz) {
        List<String> value = this.hvals(key);
        if (CollectionUtil.isEmpty(value)) {
            return null;
        }
        return value.parallelStream().map(val -> JSON.parseObject((String)val, (Class)clazz)).collect(Collectors.toList());
    }

    @Override
    public <T> T executeRedisCommand(RedisCommand<T> redisCommand) {
        return redisCommand.executeCommand(this.baseTempalte);
    }

    @Override
    public <T> List<T> hmget(String key, Collection<String> fields, Class<T> clazz) {
        return this.hmget(this.defaultDbIndex, key, fields, clazz);
    }

    @Override
    public <T> List<T> hmget(int dbIndex, String key, Collection<String> fields, Class<T> clazz) {
        Collection value = this.hmget(dbIndex, key, (Collection)fields);
        if (CollectionUtil.isEmpty((Collection)value)) {
            return null;
        }
        return value.parallelStream().map(val -> JSON.parseObject((String)val, (Class)clazz)).collect(Collectors.toList());
    }

    @Override
    public <T> Set<T> scan(String pattern, int count, Class<T> clazz) {
        return this.scan(this.defaultDbIndex, pattern, count, clazz);
    }
}

