/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.ext.jwt.springboot.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.mhuang.core.check.CheckAssert;
import tech.mhuang.ext.jwt.admin.JwtFramework;
import tech.mhuang.ext.jwt.admin.bean.Jwt;
import tech.mhuang.ext.jwt.admin.external.IJwtExternal;
import tech.mhuang.ext.jwt.springboot.configuration.JwtProperties;
import tech.mhuang.ext.jwt.springboot.configuration.SpringJwtExternal;
import tech.mhuang.ext.spring.start.SpringContextHolder;
import tech.mhuang.ext.springboot.context.SpringBootExtAutoConfiguration;

@Configuration
@ConditionalOnClass(value={JwtFramework.class})
@EnableConfigurationProperties(value={JwtProperties.class})
@ConditionalOnProperty(prefix="mhuang.jwt", name={"enable"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={SpringBootExtAutoConfiguration.class})
public class JwtAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JwtAutoConfiguration.class);
    private final JwtProperties properties;

    public JwtAutoConfiguration(JwtProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public IJwtExternal jwtExternal() {
        return new SpringJwtExternal();
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtFramework framework(IJwtExternal jwtExternal, SpringContextHolder springContextHolder) {
        CheckAssert.check((Object)((Object)this.properties), (Object)"jwt properties invalid...");
        CheckAssert.check((Object)springContextHolder, (Object)"SpringContextHolder\u4e0d\u5b58\u5728\u3001\u8bf7\u8bbe\u7f6emhuang.holder.enable=true");
        JwtFramework framework = new JwtFramework((Jwt)this.properties);
        framework.external(jwtExternal);
        framework.start();
        return framework;
    }
}

