/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils.ssl;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import tech.mgl.core.utils.MGL_FileUtils;

public class MGL_CertificateDownloader {
    public static String handleCertificate(String httpsUrl, String outputFilePath) throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }}, null);
        URL url = new URI(httpsUrl).toURL();
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
        connection.connect();
        Certificate[] serverCertificates = connection.getServerCertificates();
        if (serverCertificates.length == 0) {
            throw new IOException("No certificates found from server");
        }
        X509Certificate certificate = (X509Certificate)serverCertificates[0];
        boolean isPem = new String(certificate.getEncoded()).contains("-----BEGIN CERTIFICATE-----");
        MGL_FileUtils.getFileCreate(outputFilePath);
        if (!isPem) {
            try (FileOutputStream fos = new FileOutputStream(outputFilePath);){
                fos.write("-----BEGIN CERTIFICATE-----\n".getBytes());
                fos.write(Base64.getEncoder().encode(certificate.getEncoded()));
                fos.write("\n-----END CERTIFICATE-----\n".getBytes());
            }
        }
        try (FileOutputStream fos = new FileOutputStream(outputFilePath);){
            fos.write(certificate.getEncoded());
        }
        return outputFilePath;
    }

    public static void downloadCertificate(String httpsUrl, String outputPath) throws Exception {
        Certificate certificate;
        MGL_CertificateDownloader.disableSSLVerification();
        URL url = new URI(httpsUrl).toURL();
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.connect();
        Certificate[] certs = conn.getServerCertificates();
        if (certs.length > 0 && (certificate = certs[0]) instanceof X509Certificate) {
            X509Certificate serverCert = (X509Certificate)certificate;
            try (FileWriter writer = new FileWriter(outputPath);){
                writer.write("-----BEGIN CERTIFICATE-----\n");
                writer.write(Base64.getEncoder().encodeToString(serverCert.getEncoded()));
                writer.write("\n-----END CERTIFICATE-----");
            }
        } else {
            throw new IllegalStateException("No certificates found!");
        }
    }

    public static void fetchAndSaveCertificate(String host, int port, String outputPath) throws Exception {
        block12: {
            MGL_CertificateDownloader.disableSSLVerification();
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            try (SSLSocket socket = (SSLSocket)factory.createSocket(host, port);){
                Certificate certificate;
                socket.startHandshake();
                Certificate[] certs = socket.getSession().getPeerCertificates();
                if (certs.length > 0 && (certificate = certs[0]) instanceof X509Certificate) {
                    X509Certificate serverCert = (X509Certificate)certificate;
                    try (FileWriter writer = new FileWriter(outputPath);){
                        writer.write("-----BEGIN CERTIFICATE-----\n");
                        writer.write(Base64.getEncoder().encodeToString(serverCert.getEncoded()));
                        writer.write("\n-----END CERTIFICATE-----");
                        break block12;
                    }
                }
                throw new IllegalStateException("No valid certificate received from server.");
            }
        }
    }

    private static void disableSSLVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to disable SSL verification", e);
        }
    }

    public static void main(String[] args) throws Exception {
        MGL_CertificateDownloader.downloadCertificate("https://10.0.0.188:9200", "./test/test.crt");
    }
}

