/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils.security.gen;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Collection;
import tech.mgl.utils.security.gen.AccountDb;
import tech.mgl.utils.security.gen.OtpSource;
import tech.mgl.utils.security.gen.OtpSourceException;
import tech.mgl.utils.security.gen.PasscodeGenerator;
import tech.mgl.utils.security.gen.TotpClock;
import tech.mgl.utils.security.gen.TotpCounter;
import tech.mgl.utils.security.gen.Utilities;

public class MGL_OtpProvider
implements OtpSource {
    private static final int PIN_LENGTH = 6;
    private static final int REFLECTIVE_PIN_LENGTH = 9;
    private final TotpClock clock = new TotpClock();
    public static final int DEFAULT_INTERVAL = 30;
    private final TotpCounter mTotpCounter;

    @Override
    public String getNextCode(String accountName, String key) throws OtpSourceException {
        return this.getCurrentCode(accountName, key, null);
    }

    @Override
    public String respondToChallenge(String accountName, String key, String challenge) throws OtpSourceException {
        if (challenge == null) {
            return this.getCurrentCode(accountName, key, null);
        }
        byte[] challengeBytes = challenge.getBytes(StandardCharsets.UTF_8);
        return this.getCurrentCode(accountName, key, challengeBytes);
    }

    private String getCurrentCode(String username, String secret, byte[] challenge) throws OtpSourceException {
        if (username == null) {
            throw new OtpSourceException("No account name");
        }
        if (secret == null) {
            throw new OtpSourceException("Secret key can not empty");
        }
        OtpType type = OtpType.TOTP;
        long otp_state = 0L;
        if (type == OtpType.TOTP) {
            otp_state = this.mTotpCounter.getValueAtTime(Utilities.millisToSeconds(this.clock.currentTimeMillis()));
        } else if (type == OtpType.HOTP) {
            // empty if block
        }
        return this.computePin(secret, otp_state, challenge);
    }

    private String getEnteredKey(String key) {
        return key.replace('1', 'I').replace('0', 'O');
    }

    public MGL_OtpProvider() {
        this(30);
    }

    public MGL_OtpProvider(int interval) {
        this.mTotpCounter = new TotpCounter(interval);
    }

    private String computePin(String secret, long otp_state, byte[] challenge) throws OtpSourceException {
        if (secret == null || secret.isEmpty()) {
            throw new OtpSourceException("Null or empty secret");
        }
        try {
            PasscodeGenerator.Signer signer = AccountDb.getSigningOracle(secret);
            PasscodeGenerator pcg = new PasscodeGenerator(signer, challenge == null ? 6 : 9);
            return challenge == null ? pcg.generateResponseCode(otp_state) : pcg.generateResponseCode(otp_state, challenge);
        }
        catch (GeneralSecurityException e) {
            throw new OtpSourceException("Crypto failure", e);
        }
    }

    @Override
    public TotpCounter getTotpCounter() {
        return this.mTotpCounter;
    }

    @Override
    public int enumerateAccounts(Collection<String> result) {
        return 0;
    }

    public static enum OtpType {
        TOTP(0),
        HOTP(1);

        public final Integer value;

        private OtpType(Integer value) {
            this.value = value;
        }

        public static OtpType getEnum(Integer i) {
            for (OtpType type : OtpType.values()) {
                if (!type.value.equals(i)) continue;
                return type;
            }
            return null;
        }
    }
}

