/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils.security.gen;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.utils.security.gen.Base32String;
import tech.mgl.utils.security.gen.PasscodeGenerator;

public class AccountDb {
    private static Logger log = LoggerFactory.getLogger(AccountDb.class);
    public static final Integer DEFAULT_HOTP_COUNTER = 0;
    public static final String GOOGLE_CORP_ACCOUNT_NAME = "Google Internal 2Factor";
    private static final String ID_COLUMN = "_id";
    private static final String EMAIL_COLUMN = "email";
    private static final String SECRET_COLUMN = "secret";
    private static final String COUNTER_COLUMN = "counter";
    private static final String TYPE_COLUMN = "type";
    static final String PROVIDER_COLUMN = "provider";
    static final String TABLE_NAME = "accounts";
    static final String PATH = "databases";
    private static final String TABLE_INFO_COLUMN_NAME_COLUMN = "name";
    private static final int PROVIDER_UNKNOWN = 0;
    private static final int PROVIDER_GOOGLE = 1;
    private static final String LOCAL_TAG = "AccountDb";

    static PasscodeGenerator.Signer getSigningOracle(String secret) {
        try {
            byte[] keyBytes = AccountDb.decodeKey(secret);
            final Mac mac = Mac.getInstance("HMACSHA1");
            mac.init(new SecretKeySpec(keyBytes, ""));
            return new PasscodeGenerator.Signer(){

                @Override
                public byte[] sign(byte[] data) {
                    return mac.doFinal(data);
                }
            };
        }
        catch (Exception error) {
            log.error(error.getMessage(), (Throwable)error);
            return null;
        }
    }

    private static byte[] decodeKey(String secret) throws DecodingException, Base32String.DecodingException {
        return Base32String.decode(secret);
    }

    public static class DecodingException
    extends Exception {
        public DecodingException(String message) {
            super(message);
        }
    }

    private static class AccountDbOpenException
    extends RuntimeException {
        public AccountDbOpenException(String message, Exception e) {
            super(message, e);
        }
    }

    public static enum OtpType {
        TOTP(0),
        HOTP(1);

        public final Integer value;

        private OtpType(Integer value) {
            this.value = value;
        }

        public static OtpType getEnum(Integer i) {
            for (OtpType type : OtpType.values()) {
                if (!type.value.equals(i)) continue;
                return type;
            }
            return null;
        }
    }
}

