/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils.minio;

import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.RemoveObjectArgs;
import io.minio.UploadObjectArgs;
import io.minio.errors.MinioException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_FileIOUtils;

public class MinIOUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MinIOUtils.class.getSimpleName());
    private String fileName;
    private String file;
    private String bucket = "default";
    private String url;
    private String key = "minioadmin";
    private String secret = "minioadmin";

    public MinIOUtils setFile(String file) {
        this.file = file;
        return this;
    }

    public static MinIOUtils builder() {
        return new MinIOUtils();
    }

    public MinIOUtils setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public MinIOUtils setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public MinIOUtils setKey(String key) {
        this.key = key;
        return this;
    }

    public MinIOUtils setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    public MinIOUtils setUrl(String url) {
        this.url = url;
        return this;
    }

    public boolean delete() throws Exception {
        try {
            MinioClient minioClient = MinioClient.builder().credentials(this.key, this.secret).endpoint(this.url).build();
            RemoveObjectArgs args = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucket)).object(this.fileName)).build();
            minioClient.removeObject(args);
        }
        catch (Exception e) {
            logger.error("Error occurred: ", (Throwable)e);
            throw e;
        }
        return true;
    }

    public String upload() throws Exception {
        try {
            MinioClient minioClient = MinioClient.builder().credentials(this.key, this.secret).endpoint(this.url).build();
            boolean isExist = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.bucket)).build());
            if (isExist) {
                logger.info("Bucket already exists.");
            } else {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.bucket)).build());
            }
            if (StringUtils.isBlank((CharSequence)this.fileName)) {
                this.fileName = MGL_FileIOUtils.getRelativePath().replaceFirst("\\\\", "").replaceAll("\\\\", "/").concat(MGL_FileIOUtils.generatorFileName(this.file));
            }
            UploadObjectArgs args1 = (UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(this.bucket)).object(this.fileName)).filename(this.file).build();
            minioClient.uploadObject(args1);
            logger.info(this.file.concat(" is successfully uploaded as ").concat(this.fileName).concat(" to ").concat(this.bucket).concat(" bucket."));
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            logger.error("Error occurred: ", e);
            throw e;
        }
        return this.fileName;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(MinIOUtils.builder().setBucket("res").setUrl("http://10.0.1.55:9000").setFile("E:\\Annotation 2020-08-10 121723.png").upload());
        System.out.println(MinIOUtils.builder().setBucket("res").setUrl("http://10.0.1.55:9000").setFileName("/_mgl_up/2020/08/IMG_202008116371597110240637oe6c.png").delete());
    }
}

