/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils.minifier;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGL_MinifierUtils {
    private static final Logger log = LoggerFactory.getLogger(MGL_MinifierUtils.class);
    private static Boolean isEnvAvailable = false;
    private static Boolean isNodeAvailable = false;
    private static Boolean isNpxAvailable = false;
    private static Boolean isCleanCssAvailable = false;
    private static Boolean isTerserAvailable = false;
    private static Boolean isHtmlMinifierAvailable = false;
    private static String nodeHome = null;

    public static void setNodeHome(String home) {
        if (home != null) {
            nodeHome = home.replaceAll("[/\\\\]+$", "");
        }
        isEnvAvailable = false;
        MGL_MinifierUtils.checkNodeAvailability();
    }

    private static String getNodeCommand() {
        return nodeHome != null ? nodeHome + File.separator + "bin" + File.separator + "node" : "node";
    }

    private static String getNpxCommand() {
        return nodeHome != null ? nodeHome + File.separator + "bin" + File.separator + "npx" : "npx";
    }

    private static void checkNodeAvailability() {
        if (!isEnvAvailable.booleanValue()) {
            if (!isNodeAvailable.booleanValue()) {
                isNodeAvailable = MGL_MinifierUtils.isCommandAvailable(MGL_MinifierUtils.getNodeCommand() + " --version");
            }
            if (!isNpxAvailable.booleanValue()) {
                isNpxAvailable = MGL_MinifierUtils.isCommandAvailable(MGL_MinifierUtils.getNpxCommand() + " --version");
            }
            if (!isCleanCssAvailable.booleanValue()) {
                isCleanCssAvailable = MGL_MinifierUtils.isCommandAvailable(MGL_MinifierUtils.getNpxCommand() + " clean-css-cli --version");
            }
            if (!isTerserAvailable.booleanValue()) {
                isTerserAvailable = MGL_MinifierUtils.isCommandAvailable(MGL_MinifierUtils.getNpxCommand() + " terser --version");
            }
            if (!isHtmlMinifierAvailable.booleanValue()) {
                isHtmlMinifierAvailable = MGL_MinifierUtils.isCommandAvailable(MGL_MinifierUtils.getNpxCommand() + " html-minifier --version");
            }
            isEnvAvailable = isNodeAvailable != false && isNpxAvailable != false && isCleanCssAvailable != false && isTerserAvailable != false && isHtmlMinifierAvailable != false;
            if (!isNodeAvailable.booleanValue()) {
                System.err.println("[\u26a0 \u8b66\u544a] \u672a\u68c0\u6d4b\u5230 Node.js\uff0c\u8bf7\u5b89\u88c5\u540e\u91cd\u8bd5\uff01");
            }
            if (!isNpxAvailable.booleanValue()) {
                System.err.println("[\u26a0 \u8b66\u544a] \u672a\u68c0\u6d4b\u5230 npx\uff0c\u8bf7\u786e\u8ba4 Node.js \u662f\u5426\u5b89\u88c5\u5b8c\u6574\uff01");
            }
            if (!isCleanCssAvailable.booleanValue()) {
                System.err.println("[\u26a0 \u8b66\u544a] clean-css-cli \u672a\u5b89\u88c5\uff0cCSS \u538b\u7f29\u4e0d\u53ef\u7528\uff01\u8bf7\u6267\u884c `npm install -g clean-css-cli`");
            }
            if (!isTerserAvailable.booleanValue()) {
                System.err.println("[\u26a0 \u8b66\u544a] terser \u672a\u5b89\u88c5\uff0cJS \u538b\u7f29\u4e0d\u53ef\u7528\uff01\u8bf7\u6267\u884c `npm install -g terser`");
            }
            if (!isHtmlMinifierAvailable.booleanValue()) {
                System.err.println("[\u26a0 \u8b66\u544a] html-minifier \u672a\u5b89\u88c5\uff0cHTML \u538b\u7f29\u4e0d\u53ef\u7528\uff01\u8bf7\u6267\u884c `npm install -g html-minifier`");
            }
        }
    }

    private static void setProcessBuilderEnv(ProcessBuilder processBuilder) {
        if (nodeHome != null) {
            processBuilder.environment().put("NODE_HOME", nodeHome);
            String currentPath = processBuilder.environment().get("PATH");
            if (currentPath != null) {
                processBuilder.environment().put("PATH", currentPath + ":" + processBuilder.environment().get("NODE_HOME") + File.separator + "bin");
            }
        }
    }

    private static boolean isCommandAvailable(String command) {
        try {
            System.out.println("Command: " + command);
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            MGL_MinifierUtils.setProcessBuilderEnv(processBuilder);
            processBuilder.command("/bin/bash", "-c", command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int waitFor = process.waitFor();
            System.out.println("process.waitFor() :: == " + waitFor);
            return waitFor == 0;
        }
        catch (IOException | InterruptedException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public static void minifyFile(String inputFile, String outputFile, String type) throws IOException {
        if (!MGL_MinifierUtils.isToolAvailable(type).booleanValue()) {
            return;
        }
        String[] command = MGL_MinifierUtils.buildCommand(inputFile, outputFile, type);
        MGL_MinifierUtils.executeCommand(command);
    }

    public static String minifyContent(String content, String type) throws IOException {
        if (!MGL_MinifierUtils.isToolAvailable(type).booleanValue()) {
            return content;
        }
        File tempInputFile = File.createTempFile("input" + System.currentTimeMillis(), "." + type);
        File tempOutputFile = File.createTempFile("output" + System.currentTimeMillis(), "." + type);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tempInputFile));){
            writer.write(content);
        }
        String[] command = MGL_MinifierUtils.buildCommand(tempInputFile.getAbsolutePath(), tempOutputFile.getAbsolutePath(), type);
        MGL_MinifierUtils.executeCommand(command);
        String result = Files.readString(tempOutputFile.toPath());
        tempOutputFile.delete();
        tempInputFile.delete();
        return result;
    }

    private static Boolean isToolAvailable(String type) {
        switch (type.toLowerCase()) {
            case "css": 
            case "scss": {
                if (isCleanCssAvailable.booleanValue()) break;
                System.err.println("[\u26a0 \u8b66\u544a] CSS \u538b\u7f29\u5de5\u5177 clean-css-cli \u4e0d\u53ef\u7528\uff01");
                return false;
            }
            case "js": 
            case "ts": {
                if (isTerserAvailable.booleanValue()) break;
                System.err.println("[\u26a0 \u8b66\u544a] JS \u538b\u7f29\u5de5\u5177 terser \u4e0d\u53ef\u7528\uff01");
                return false;
            }
            case "html": 
            case "htm": {
                if (isHtmlMinifierAvailable.booleanValue()) break;
                System.err.println("[\u26a0 \u8b66\u544a] HTML \u538b\u7f29\u5de5\u5177 html-minifier \u4e0d\u53ef\u7528\uff01");
                return false;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + type);
            }
        }
        return true;
    }

    private static String[] buildCommand(String inputFile, String outputFile, String type) {
        String[] stringArray;
        switch (type.toLowerCase()) {
            case "css": {
                String[] stringArray2 = new String[5];
                stringArray2[0] = MGL_MinifierUtils.getNpxCommand();
                stringArray2[1] = "clean-css-cli";
                stringArray2[2] = "-o";
                stringArray2[3] = outputFile;
                stringArray = stringArray2;
                stringArray2[4] = inputFile;
                break;
            }
            case "js": {
                String[] stringArray3 = new String[7];
                stringArray3[0] = MGL_MinifierUtils.getNpxCommand();
                stringArray3[1] = "terser";
                stringArray3[2] = inputFile;
                stringArray3[3] = "-o";
                stringArray3[4] = outputFile;
                stringArray3[5] = "--compress";
                stringArray = stringArray3;
                stringArray3[6] = "--mangle";
                break;
            }
            case "html": {
                String[] stringArray4 = new String[7];
                stringArray4[0] = MGL_MinifierUtils.getNpxCommand();
                stringArray4[1] = "html-minifier";
                stringArray4[2] = "--collapse-whitespace";
                stringArray4[3] = "--remove-comments";
                stringArray4[4] = "-o";
                stringArray4[5] = outputFile;
                stringArray = stringArray4;
                stringArray4[6] = inputFile;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + type);
            }
        }
        return stringArray;
    }

    private static void executeCommand(String command) throws IOException {
        MGL_MinifierUtils.executeCommand(command.split(" "));
    }

    private static void executeCommand(String[] command) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        MGL_MinifierUtils.setProcessBuilderEnv(processBuilder);
        processBuilder.command("/bin/bash", "-c", String.join((CharSequence)" ", command));
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }).start();
        try {
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new IOException("Minification failed with exit code: " + exitCode);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Minification process was interrupted", e);
        }
    }

    public static void main(String[] args) {
        try {
            MGL_MinifierUtils.setNodeHome("/home/bo/.nvm/versions/node/v22.13.0/");
            MGL_MinifierUtils.executeCommand("env");
            MGL_MinifierUtils.executeCommand("node --version");
            MGL_MinifierUtils.setNodeHome("/home/bo/.nvm/versions/node/v22.13.0/");
            MGL_MinifierUtils.minifyFile("/home/bo/Dev/Workspaces/2025-OT/mgl-cms-template/www/hinggan_PC/main.css", "output.min.css", "css");
            String css = "\n:root {\n  --default-font: \"\u5fae\u8f6f\u96c5\u9ed1\",  system-ui, -apple-system, \"Segoe UI\", Roboto, \"Helvetica Neue\", Arial, \"Noto Sans\", \"Liberation Sans\", sans-serif, \"Apple Color Emoji\", \"Segoe UI Emoji\", \"Segoe UI Symbol\", \"Noto Color Emoji\";\n  --heading-font: \"Raleway\",  sans-serif;\n  --nav-font: \"Poppins\",  sans-serif;\n}\n\n\n:root { \n  --background-color: #ffffff; \n  --default-color: #555555; \n  --heading-color: #1e4356; \n  --accent-color: #0dcaf0; \n  --surface-color: #ffffff; \n  --contrast-color: #ffffff; \n}\n\n\n:root {\n  --nav-color: #ffffff;  \n  --nav-hover-color: #0dcaf0; \n  --nav-active-color: #0dcaf0;\n  --nav-mobile-background-color: #ffffff; \n  --nav-dropdown-background-color: #ffffff; \n  --nav-dropdown-color: #555555; \n  --nav-dropdown-hover-color: #68a4c4; \n}\n\nmain.main {\n\tbackground-image: url(https://assets.xammyy.com.cn/xmmyy/resources/image/2025/02/23/647813565272133.jpg);\n    background-size: 17rem;\n}\n\n.light-background {\n  --background-color: #ffffff;\n  --surface-color: #ffffff;\n}\n\n.dark-background {\n  --background-color: #007bc4;\n  --default-color: #ffffff;\n  --heading-color: #ffffff;\n  --surface-color: #284e62;\n  --contrast-color: #ffffff;\n}\n\n/* Smooth scroll */\n:root {\n  scroll-behavior: smooth;\n}\n\nbody {\n  color: var(--default-color);\n  background-color: var(--background-color);\n  font-family: var(--default-font);\n}\n\na {\n  color: var(--accent-color);\n  text-decoration: none;\n  transition: 0.3s;\n}\n\na:hover {\n  color: color-mix(in srgb, var(--accent-color), transparent 25%);\n  text-decoration: none;\n}\n\nh1,\nh2,\nh3,\nh4,\nh5,\nh6 {\n  color: var(--heading-color);\n  font-family: var(--heading-font);\n}\n\n@keyframes img {\n  0% {\n    transform: scale(1, 1);\n    \n  }\n\n  100% {\n    transform: scale(1.3, 1.3);\n    \n  }\n}\n\n/*--------------------------------------------------------------\n# Global Header\n--------------------------------------------------------------*/\n.header {\n  --background-color: \nar-gradient(180deg, #000000d4, transparent);\n  --default-color: #ffffff;\n  --heading-color: #ffffff;\n  color: var(--default-color);\n  background: var(--background-color);\n  padding: 15px 0;\n  transition: all 0.5s;\n  z-index: 997;\n}\n\n.header .logo {\n  line-height: 1;\n}\n\n.header .logo img {\n  max-height: 32px;\n  margin-right: 8px;\n    max-width: 215px;\n    max-height: 100%;\n}\n\n.header .logo h1 {\n  font-size: 30px;\n  margin: 0;\n  font-weight: 700;\n  color: var(--heading-color);\n}\n\n/* Global Header on Scroll\n------------------------------*/\n.scrolled .header {\n  --background-color: #007bc4;\n}\n\n.navmenu {\n\ttext-align: right;\n}\n\n\n@media (min-width: 1200px) {\n  .navmenu {\n    padding: 0;\n  }\n\n  .navmenu ul {\n    margin: 0;\n    padding: 0;\n    display: flex;\n    list-style: none;\n    align-items: center;\n  }\n\n  .navmenu li {\n    position: relative;\n  }\n\n  .navmenu a,\n  .navmenu a:focus {\n    color: var(--nav-color);\n    padding: 18px 15px;\n    font-size: 16px;\n    font-family: var(--nav-font);\n    font-weight: 400;\n    display: flex;\n    align-items: center;\n    justify-content: space-between;\n    white-space: nowrap;\n    transition: 0.3s;\n\t\tpadding-top: 0;\n  }\n\n  .navmenu a i,\n  .navmenu a:focus i {\n    font-size: 12px;\n    line-height: 0;\n    margin-left: 5px;\n    transition: 0.3s;\n  }\n\n  .navmenu li:last-child a {\n    padding-right: 0;\n  }\n\n  .navmenu li:hover>a,\n  .navmenu .active,\n  .navmenu .active:focus {\n    color: var(--nav-hover-color);\n  }\n\n  .navmenu .dropdown ul {\n    margin: 0;\n    padding: 10px 0;\n    background: var(--nav-dropdown-background-color);\n    display: block;\n    position: absolute;\n    visibility: hidden;\n    left: 14px;\n    top: 130%;\n    opacity: 0;\n    transition: 0.3s;\n    border-radius: 4px;\n    z-index: 99;\n    box-shadow: 0px 0px 30px rgba(0, 0, 0, 0.1);\n  }\n\n  .navmenu .dropdown ul li {\n    min-width: 200px;\n  }\n\n  .navmenu .dropdown ul a {\n    padding: 10px 20px;\n    font-size: 15px;\n    text-transform: none;\n    color: var(--nav-dropdown-color);\n  }\n\n  .navmenu .dropdown ul a i {\n    font-size: 12px;\n  }\n\n  .navmenu .dropdown ul a:hover,\n  .navmenu .dropdown ul .active:hover,\n  .navmenu .dropdown ul li:hover>a {\n    color: var(--nav-dropdown-hover-color);\n  }\n\n  .navmenu .dropdown:hover>ul {\n    opacity: 1;\n    top: 100%;\n    visibility: visible;\n  }\n\n  .navmenu .dropdown .dropdown ul {\n    top: 0;\n    left: -90%;\n    visibility: hidden;\n  }\n\n  .navmenu .dropdown .dropdown:hover>ul {\n    opacity: 1;\n    top: 0;\n    left: -100%;\n    visibility: visible;\n  }\n}\n\n\n@media (max-width: 1199px) {\n  .mobile-nav-toggle {\n    color: var(--nav-color);\n    font-size: 28px;\n    line-height: 0;\n    margin-right: 10px;\n    cursor: pointer;\n    transition: color 0.3s;\n  }\n\n  .navmenu {\n    padding: 0;\n    z-index: 9997;\n  }\n\n  .navmenu ul {\n    display: none;\n    list-style: none;\n    position: absolute;\n    inset: 60px 20px 20px 20px;\n    padding: 10px 0;\n    margin: 0;\n    border-radius: 6px;\n    background-color: var(--nav-mobile-background-color);\n    overflow-y: auto;\n    transition: 0.3s;\n    z-index: 9998;\n    box-shadow: 0px 0px 30px rgba(0, 0, 0, 0.1);\n  }\n\n  .navmenu a,\n  .navmenu a:focus {\n    color: var(--nav-dropdown-color);\n    padding: 10px 20px;\n    font-family: var(--nav-font);\n    font-size: 17px;\n    font-weight: 500;\n    display: flex;\n    align-items: center;\n    justify-content: space-between;\n    white-space: nowrap;\n    transition: 0.3s;\n  }\n\n  .navmenu a i,\n  .navmenu a:focus i {\n    font-size: 12px;\n    line-height: 0;\n    margin-left: 5px;\n    width: 30px;\n    height: 30px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    border-radius: 50%;\n    transition: 0.3s;\n    background-color: color-mix(in srgb, var(--accent-color), transparent 90%);\n  }\n\n  .navmenu a i:hover,\n  .navmenu a:focus i:hover {\n    background-color: var(--accent-color);\n    color: var(--contrast-color);\n  }\n\n  .navmenu a:hover,\n  .navmenu .active,\n  .navmenu .active:focus {\n    color: var(--nav-dropdown-hover-color);\n  }\n\n  .navmenu .active i,\n  .navmenu .active:focus i {\n    background-color: var(--accent-color);\n    color: var(--contrast-color);\n    transform: rotate(180deg);\n  }\n\n  .navmenu .dropdown ul {\n    position: static;\n    display: none;\n    z-index: 99;\n    padding: 10px 0;\n    margin: 10px 20px;\n    background-color: var(--nav-dropdown-background-color);\n    border: 1px solid color-mix(in srgb, var(--default-color), transparent 90%);\n    box-shadow: none;\n    transition: all 0.5s ease-in-out;\n  }\n\n  .navmenu .dropdown ul ul {\n    background-color: rgba(33, 37, 41, 0.1);\n  }\n\n  .navmenu .dropdown>.dropdown-active {\n    display: block;\n    background-color: rgba(33, 37, 41, 0.03);\n  }\n\n  .mobile-nav-active {\n    overflow: hidden;\n  }\n\n  .mobile-nav-active .mobile-nav-toggle {\n    color: #fff;\n    position: absolute;\n    font-size: 32px;\n    top: 15px;\n    right: 15px;\n    margin-right: 0;\n    z-index: 9999;\n  }\n\n  .mobile-nav-active .navmenu {\n    position: fixed;\n    overflow: hidden;\n    inset: 0;\n    background: rgba(33, 37, 41, 0.8);\n    transition: 0.3s;\n  }\n\n  .mobile-nav-active .navmenu>ul {\n    display: block;\n  }\n\n\t#footer .text-right {\n\t\ttext-align: left !important;\n\t}\n}\n\n@media (max-width: 768px) { \n\t#footer .text-right {\n\t\ttext-align: left !important;\n\t}\n\n\t.right-cornner {\n\t\t\tdisplay: none;\n\t}\n}\n\n/*--------------------------------------------------------------\n# Global Footer\n--------------------------------------------------------------*/\n.footer {\n  color: var(--default-color);\n  background-color: var(--background-color);\n  font-size: 14px;\n  position: relative;\n}\n\n.footer .footer-newsletter {\n  background-color: color-mix(in srgb, var(--default-color), transparent 97%);\n  padding: 50px 0;\n}\n\n.footer .footer-newsletter h4 {\n  font-size: 24px;\n}\n\n.footer .footer-top {\n  //padding-top: 50px;\n}\n\n.footer .social-links a {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  width: 40px;\n  height: 40px;\n  border-radius: 50%;\n  border: 1px solid color-mix(in srgb, var(--default-color), transparent 50%);\n  font-size: 16px;\n  color: color-mix(in srgb, var(--default-color), transparent 20%);\n  margin-right: 10px;\n  transition: 0.3s;\n}\n\n.footer .social-links a:hover {\n  color: var(--accent-color);\n  border-color: var(--accent-color);\n}\n\n.footer h4 {\n  font-size: 16px;\n  font-weight: bold;\n  position: relative;\n  padding-bottom: 12px;\n}\n\n.footer .footer-links {\n  //margin-bottom: 30px;\n}\n\n.footer .footer-links ul {\n  list-style: none;\n  padding: 0;\n  margin: 0;\n}\n\n.footer .footer-links ul i {\n  margin-right: 3px;\n  font-size: 12px;\n  line-height: 0;\n  color: var(--accent-color);\n}\n\n.footer .footer-links ul li {\n  padding: 10px 0;\n  display: flex;\n  align-items: center;\n}\n\n.footer .footer-links ul li:first-child {\n  //padding-top: 0;\n}\n\n.footer .footer-links ul a {\n  display: inline-block;\n  color: color-mix(in srgb, var(--default-color), transparent 20%);\n  line-height: 1;\n}\n\n.footer .footer-links ul a:hover {\n  color: var(--accent-color);\n}\n\n.footer .footer-about a {\n  color: var(--heading-color);\n  font-size: 24px;\n  font-weight: 600;\n  font-family: var(--heading-font);\n}\n\n.footer .footer-contact p {\n  margin-bottom: 5px;\n}\n\n.footer .copyright {\n  //padding: 25px 0;\n  border-top: 1px solid color-mix(in srgb, var(--default-color), transparent 90%);\n    background: #0088ff;\n}\n\n.footer .copyright p {\n  margin-bottom: 0;\n}\n\n.footer .copyright p > *{\n  padding: 0.3rem;\n}\n\n\n/*--------------------------------------------------------------\n# Preloader\n--------------------------------------------------------------*/\n#preloader {\n  position: fixed;\n  inset: 0;\n  z-index: 999999;\n  overflow: hidden;\n  background: var(--background-color);\n  transition: all 0.6s ease-out;\n}\n\n#preloader:before {\n  content: \"\";\n  position: fixed;\n  top: calc(50% - 30px);\n  left: calc(50% - 30px);\n  border: 6px solid #ffffff;\n  border-color: var(--accent-color) transparent var(--accent-color) transparent;\n  border-radius: 50%;\n  width: 60px;\n  height: 60px;\n  animation: animate-preloader 1.5s linear infinite;\n}\n\n@keyframes animate-preloader {\n  0% {\n    transform: rotate(0deg);\n  }\n\n  100% {\n    transform: rotate(360deg);\n  }\n}\n\n/*--------------------------------------------------------------\n# Scroll Top Button\n--------------------------------------------------------------*/\n.scroll-top {\n  position: fixed;\n  visibility: hidden;\n  opacity: 0;\n  right: 15px;\n  bottom: 15px;\n  z-index: 99999;\n  background-color: var(--accent-color);\n  width: 40px;\n  height: 40px;\n  border-radius: 2rem;\n  transition: all 0.4s;\n}\n\n.scroll-top i {\n  font-size: 24px;\n  color: var(--contrast-color);\n  line-height: 0;\n}\n\n.scroll-top:hover {\n  background-color: color-mix(in srgb, var(--accent-color), transparent 20%);\n  color: var(--contrast-color);\n}\n\n.scroll-top.active {\n  visibility: visible;\n  opacity: 1;\n}\n\n/*--------------------------------------------------------------\n# Disable aos animation delay on mobile devices\n--------------------------------------------------------------*/\n@media screen and (max-width: 768px) {\n  [data-aos-delay] {\n    transition-delay: 0 !important;\n  }\n}\n\n/*--------------------------------------------------------------\n# Global Page Titles & Breadcrumbs\n--------------------------------------------------------------*/\n.page-title {\n  color: var(--default-color);\n  background-color: var(--background-color);\n  padding: 200px 0 80px 0;\n  text-align: center;\n  position: relative;\n}\n\n.page-title:before {\n  content: \"\";\n  background-color: color-mix(in srgb, var(--background-color), transparent 50%);\n  position: absolute;\n  inset: 0;\n\tbackground-image: url(https://assets.xammyy.com.cn/xmmyy/resources/image/2025/02/26/648779339661381.jpg);\n\topacity: 0.7;\n\n    background-repeat: no-repeat;\n    background-position: left;\n    background-size: cover;\n}\n\n.page-title h1 {\n  font-size: 42px;\n  font-weight: 700;\n  margin-bottom: 10px;\n}\n\n.page-title .breadcrumbs ol {\n  display: flex;\n  flex-wrap: wrap;\n  list-style: none;\n  justify-content: center;\n  padding: 0;\n  margin: 0;\n  font-size: 16px;\n  font-weight: 400;\n}\n\n.page-title .breadcrumbs ol li+li {\n  padding-left: 10px;\n}\n\n.page-title .breadcrumbs ol li+li::before {\n  content: \"/\";\n  display: inline-block;\n  padding-right: 10px;\n  color: color-mix(in srgb, var(--default-color), transparent 50%);\n}\n\n/*--------------------------------------------------------------\n# Global Sections\n--------------------------------------------------------------*/\nsection,\n.section {\n  color: var(--default-color);\n  //background-color: var(--background-color);\n  padding: 2rem 0;\n  scroll-margin-top: 90px;\n  overflow: clip;\n\t//background-image: url(https://assets.xammyy.com.cn/xmmyy/resources/image/2025/02/23/647813565272133.jpg);\n\tbackground-size: 17rem;\n}\n\n@media (max-width: 1199px) {\n\n  section,\n  .section {\n    scroll-margin-top: 66px;\n  }\n}\n\n/*--------------------------------------------------------------\n# Global Section Titles\n--------------------------------------------------------------*/\n.section-title {\n  text-align: center;\n  padding-bottom: 1rem;\n  position: relative;\n}\n\n.section-title h2 {\n  font-size: 32px;\n  font-weight: 700;\n  margin-bottom: 0;\n  padding-bottom: 0;\n  position: relative;\n}\n\n.section-title h2:before {\n  //content: \"\";\n  //position: absolute;\n  //display: block;\n // width: 160px;\n  //height: 1px;\n  //background: color-mix(in srgb, var(--default-color), transparent 60%);\n  //left: 0;\n  //right: 0;\n  //bottom: 1px;\n  //margin: auto;\n}\n\n.section-title h2::after {\n    content: \"\";\n    /* position: absolute; */\n    display: block;\n    width: 100%;\n    height: 3rem;\n    /* background: var(--accent-color); */\n    left: 0;\n    right: 0;\n    bottom: 0;\n    margin: auto;\n    background-image: url(https://assets.xammyy.com.cn/xmmyy/resources/image/2025/02/23/647764029562949.png);\n    background-repeat: repeat-x;\n    background-position: 0;\n    /* height: 100%; */\n    background-size: 10rem;\n    top: 4rem;\n}\n\n.section-title p {\n  margin-bottom: 0;\n}\n\n/*--------------------------------------------------------------\n# Hero Section\n--------------------------------------------------------------*/\n.hero {\n  width: 100%;\n  min-height: 80vh;\n  overflow: hidden;\n  display: flex;\n  align-items: center;\n  position: relative;\n  background-color: transparent;\n\tpadding: 0;\n}\n\n.hero::after {\n  content: \"\";\n  position: absolute;\n  left: 50%;\n  top: 0;\n  width: 130%;\n  height: 95%;\n  background: linear-gradient(to right, color-mix(in srgb, var(--background-color), transparent 90%), var(--background-color)), url(\"../img/cover.png\") center top no-repeat;\n  //background: url(\"../img/cover.png\") center top no-repeat;\n  background-size: cover;\n  z-index: 0;\n  \n  transform: translateX(-50%) rotate(0deg);\n  border-radius: 0 0 50% 50%;\n}\n\n\n.hero::before {\n  content: \"\";\n  position: absolute;\n  left: 50%;\n  top: 0;\n  width: 130%;\n  height: 96%;\n  background: var(--background-color);\n  opacity: 0.3;\n  z-index: 0;\n  border-radius: 0 0 50% 50%;\n  transform: translateX(-50%) translateY(18px) rotate(2deg);\n}\n\n.hero img {\n  //position: absolute;\n  inset: 0;\n  display: block;\n  width: 100%;\n  height: 100%;\n  object-fit: cover;\n  z-index: 1;\n}\n\n.hero .carousel {\n  position: relative;\n  width: 100%;\n  display: flex;\n  align-items: center;\n  z-index: 3;\n}\n\n.hero .carousel-container {\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  flex-direction: column;\n  text-align: center;\n}\n\n.hero h2 {\n  margin-bottom: 30px;\n  font-size: 48px;\n  font-weight: 700;\n  animation: fadeInDown 1s both;\n  display: block;\n}\n\n.hero p {\n  width: 80%;\n  margin: 0 auto 30px auto;\n  color: color-mix(in srgb, var(--default-color), transparent 20%);\n  animation: fadeInDown 1s both 0.2s;\n}\n\n.hero .carousel-control-prev,\n.hero .carousel-control-next {\n  width: 10%;\n}\n\n.hero .carousel-control-next-icon,\n.hero .carousel-control-prev-icon {\n  background: none;\n  font-size: 48px;\n  line-height: 1;\n  width: auto;\n  height: auto;\n}\n\n.hero .btn-get-started {\n  font-weight: 500;\n  font-size: 14px;\n  letter-spacing: 1px;\n  display: inline-block;\n  padding: 12px 32px;\n  border-radius: 50px;\n  transition: 0.5s;\n  line-height: 1;\n  margin: 10px;\n  color: var(--default-color);\n  animation: fadeInUp 1s both 0.4s;\n  border: 2px solid var(--accent-color);\n}\n\n.hero .btn-get-started:hover {\n  background: var(--accent-color);\n  color: var(--contrast-color);\n  text-decoration: none;\n}\n\n.hero .carousel-indicators {\n  bottom: -60px;\n}\n\n.hero .carousel-indicators li {\n  cursor: pointer;\n  background: var(--default-color);\n  overflow: hidden;\n  border: 0;\n  width: 12px;\n  height: 12px;\n  border-radius: 50px;\n  opacity: 0.3;\n  transition: 0.3s;\n}\n\n.hero .carousel-indicators li.active {\n  opacity: 1;\n  background: var(--accent-color);\n}\n\n@media (min-width: 1024px) {\n  .hero p {\n    width: 60%;\n  }\n\n  .hero .carousel-control-prev,\n  .hero .carousel-control-next {\n    width: 5%;\n  }\n}\n\n@media (max-width: 768px) {\n  .hero h2 {\n    font-size: 28px;\n  }\n\n\t.col .description, .index_search , .left-bottom-cornner {\n\t\tdisplay: none !important;\n\t}\n\n\t.mgl-list-group-item,.mgl-list-group-item .text {\n\t\twidth: auto !important;\n\t}\n\n}\n\n@keyframes fadeInUp {\n  from {\n    opacity: 0;\n    transform: translate3d(0, 100%, 0);\n  }\n\n  to {\n    opacity: 1;\n    transform: translate3d(0, 0, 0);\n  }\n}\n\n@keyframes fadeInDown {\n  from {\n    opacity: 0;\n    transform: translate3d(0, -100%, 0);\n  }\n\n  to {\n    opacity: 1;\n    transform: translate3d(0, 0, 0);\n  }\n}\n\n/*--------------------------------------------------------------\n# Featured Services Section\n--------------------------------------------------------------*/\n.featured-services {\n  --cyan-color: #0dcaf0;\n  --orange-color: #fd7e14;\n  --teal-color: #20c997;\n  --red-color: #df1529;\n}\n\n.featured-services .service-item {\n  background-color: var(--surface-color);\n  box-shadow: 0px 5px 90px 0px rgba(0, 0, 0, 0.1);\n  height: 100%;\n  padding: 40px 30px;\n  text-align: center;\n  transition: 0.3s;\n  border-radius: 5px;\n  border: 1px solid transparent;\n}\n\n.featured-services .service-item .icon {\n  margin: 0 auto;\n  width: 64px;\n  height: 64px;\n  display: flex;\n  border-radius: 50%;\n  align-items: center;\n  justify-content: center;\n  transition: ease-in-out 0.3s;\n  position: relative;\n}\n\n.featured-services .service-item .icon i {\n  font-size: 28px;\n  transition: 0.5s;\n  position: relative;\n}\n\n.featured-services .service-item h3 {\n  font-weight: 700;\n  margin: 10px 0 15px 0;\n  font-size: 22px;\n}\n\n.featured-services .service-item p {\n  line-height: 24px;\n  font-size: 14px;\n  margin-bottom: 0;\n}\n\n.featured-services .service-item:hover {\n  box-shadow: 0px 5px 35px 0px rgba(0, 0, 0, 0.1);\n}\n\n.featured-services .service-item.item-cyan .icon {\n  background-color: color-mix(in srgb, var(--cyan-color) 10%, white 95%);\n}\n\n.featured-services .service-item.item-cyan .icon i {\n  color: var(--cyan-color);\n}\n\n.featured-services .service-item.item-cyan:hover {\n  border-color: var(--cyan-color);\n}\n\n.featured-services .service-item.item-cyan:hover .icon {\n  background-color: var(--cyan-color);\n}\n\n.featured-services .service-item.item-cyan:hover .icon i {\n  color: var(--contrast-color);\n}\n\n.featured-services .service-item.item-orange .icon {\n  background-color: color-mix(in srgb, var(--orange-color) 10%, white 95%);\n}\n\n.featured-services .service-item.item-orange .icon i {\n  color: var(--orange-color);\n}\n\n.featured-services .service-item.item-orange:hover {\n  border-color: var(--orange-color);\n}\n\n.featured-services .service-item.item-orange:hover .icon {\n  background-color: var(--orange-color);\n}\n\n.featured-services .service-item.item-orange:hover .icon i {\n  color: var(--contrast-color);\n}\n\n.featured-services .service-item.item-teal .icon {\n  background-color: color-mix(in srgb, var(--teal-color) 10%, white 95%);\n}\n\n.featured-services .service-item.item-teal .icon i {\n  color: var(--teal-color);\n}\n\n.featured-services .service-item.item-teal:hover {\n  border-color: var(--teal-color);\n}\n\n.featured-services .service-item.item-teal:hover .icon {\n  background-color: var(--teal-color);\n}\n\n.featured-services .service-item.item-teal:hover .icon i {\n  color: var(--contrast-color);\n}\n\n.featured-services .service-item.item-red .icon {\n  background-color: color-mix(in srgb, var(--red-color) 10%, white 95%);\n}\n\n.featured-services .service-item.item-red .icon i {\n  color: var(--red-color);\n}\n\n.featured-services .service-item.item-red:hover {\n  border-color: var(--red-color);\n}\n\n.featured-services .service-item.item-red:hover .icon {\n  background-color: var(--red-color);\n}\n\n.featured-services .service-item.item-red:hover .icon i {\n  color: var(--contrast-color);\n}\n\n/*--------------------------------------------------------------\n# About Section\n--------------------------------------------------------------*/\n.about .content h3 {\n  font-size: 1.75rem;\n  font-weight: 700;\n}\n\n.about .content ul {\n  list-style: none;\n  padding: 0;\n}\n\n.about .content ul li {\n  padding: 10px 0 0 0;\n  display: flex;\n}\n\n.about .content ul i {\n  color: var(--accent-color);\n  margin-right: 0.5rem;\n  line-height: 1.2;\n  font-size: 1.25rem;\n}\n\n.about .content p:last-child {\n  margin-bottom: 0;\n}\n\n.about .pulsating-play-btn {\n  position: absolute;\n  left: calc(50% - 47px);\n  top: calc(50% - 47px);\n}\n\n/*--------------------------------------------------------------\n# Features Section\n--------------------------------------------------------------*/\n.features .features-item {\n  color: color-mix(in srgb, var(--default-color), transparent 20%);\n}\n\n.features .features-item+.features-item {\n  margin-top: 100px;\n}\n\n@media (max-width: 640px) {\n  .features .features-item+.features-item {\n    margin-top: 40px;\n  }\n}\n\n.features .features-item h3 {\n  font-weight: 700;\n  font-size: 26px;\n}\n\n.features .features-item ul {\n  list-style: none;\n  padding: 0;\n}\n\n.features .features-item ul li {\n  padding-bottom: 10px;\n  display: flex;\n  align-items: center;\n}\n\n.features .features-item ul li:last-child {\n  padding-bottom: 0;\n}\n\n.features .features-item ul i {\n  font-size: 20px;\n  padding-right: 4px;\n  color: var(--accent-color);\n}\n\n.features .features-item p:last-child {\n  margin-bottom: 0;\n}\n\n/*--------------------------------------------------------------\n# Stats Section\n--------------------------------------------------------------*/\n.stats .stats-item {\n  padding: 30px;\n  width: 100%;\n}\n\n.stats .stats-item span {\n  font-size: 48px;\n  display: block;\n  color: var(--accent-color);\n  font-weight: 700;\n}\n\n.stats .stats-item p {\n  color: color-mix(in srgb, var(--default-color), transparent 40%);\n  padding: 0;\n  margin: 0;\n  font-family: var(--heading-font);\n  font-size: 15px;\n  font-weight: 600;\n}\n\n/*--------------------------------------------------------------\n# Clients Section\n--------------------------------------------------------------*/\n.clients .swiper {\n  padding: 10px 0;\n}\n\n.clients .swiper-wrapper {\n  height: auto;\n}\n\n.clients .swiper-slide img {\n  transition: 0.3s;\n}\n\n.clients .swiper-slide img:hover {\n  transform: scale(1.1);\n}\n\n/*--------------------------------------------------------------\n# Skills Section\n--------------------------------------------------------------*/\n.skills .progress {\n  height: 60px;\n  display: block;\n  background: none;\n  border-radius: 0;\n}\n\n.skills .progress .skill {\n  color: var(--heading-color);\n  padding: 0;\n  margin: 0 0 6px 0;\n  text-transform: uppercase;\n  display: block;\n  font-weight: 600;\n  font-family: var(--heading-font);\n}\n\n.skills .progress .skill .val {\n  float: right;\n  font-style: normal;\n}\n\n.skills .progress-bar-wrap {\n  background: color-mix(in srgb, var(--default-color), transparent 90%);\n  height: 10px;\n}\n\n.skills .progress-bar {\n  width: 1px;\n  height: 10px;\n  transition: 0.9s;\n  background-color: var(--accent-color);\n}\n\n/*--------------------------------------------------------------\n# Testimonials Section\n--------------------------------------------------------------*/\n.testimonials .section-header {\n  margin-bottom: 40px;\n}\n\n.testimonials .testimonials-carousel,\n.testimonials .testimonials-slider {\n  overflow: hidden;\n}\n\n.testimonials .testimonial-item {\n  text-align: center;\n}\n\n.testimonials .testimonial-item .testimonial-img {\n  width: 120px;\n  border-radius: 50%;\n  border: 4px solid var(--background-color);\n  margin: 0 auto;\n}\n\n.testimonials .testimonial-item h3 {\n  font-size: 20px;\n  font-weight: bold;\n  margin: 10px 0 5px 0;\n}\n\n.testimonials .testimonial-item h4 {\n  font-size: 14px;\n  color: color-mix(in srgb, var(--default-color), transparent 40%);\n  margin: 0 0 15px 0;\n}\n\n.testimonials .testimonial-item .stars {\n  margin-bottom: 15px;\n}\n\n.testimonials .testimonial-item .stars i {\n  color: #ffc107;\n  margin: 0 1px;\n}\n\n.testimonials .testimonial-item .quote-icon-left,\n.testimonials .testimonial-item .quote-icon-right {\n  color: color-mix(in srgb, var(--accent-color), transparent 50%);\n  font-size: 26px;\n  line-height: 0;\n}\n\n.testimonials .testimonial-item .quote-icon-left {\n  display: inline-block;\n  left: -5px;\n  position: relative;\n}\n\n.testimonials .testimonial-item .quote-icon-right {\n  display: inline-block;\n  right: -5px;\n  position: relative;\n  top: 10px;\n  transform: scale(-1, -1);\n}\n\n.testimonials .testimonial-item p {\n  font-style: italic;\n  margin: 0 auto 15px auto;\n}\n\n.testimonials .swiper-wrapper {\n  height: auto;\n}\n\n.testimonials .swiper-pagination {\n  margin-top: 20px;\n  position: relative;\n}\n\n.testimonials .swiper-pagination .swiper-pagination-bullet {\n  width: 12px;\n  height: 12px;\n  opacity: 1;\n  background-color: color-mix(in srgb, var(--default-color), transparent 85%);\n}\n\n.testimonials .swiper-pagination .swiper-pagination-bullet-active {\n  background-color: var(--accent-color);\n}\n\n@media (min-width: 992px) {\n  .testimonials .testimonial-item p {\n    width: 80%;\n  }\n}\n\n/*--------------------------------------------------------------\n# Service Details Section\n--------------------------------------------------------------*/\n.details .service-box {\n  background-color: var(--surface-color);\n  padding: 20px;\n  box-shadow: 0px 2px 20px rgba(0, 0, 0, 0.1);\n}\n\n.details .service-box+.service-box {\n  margin-top: 30px;\n}\n\n.details .service-box h4 {\n  font-size: 20px;\n  font-weight: 700;\n  border-bottom: 2px solid color-mix(in srgb, var(--default-color), transparent 92%);\n  padding-bottom: 15px;\n  margin-bottom: 15px;\n}\n\n.details .services-list {\n  background-color: var(--surface-color);\n}\n\n.details .services-list a {\n  color: color-mix(in srgb, var(--default-color), transparent 20%);\n  background-color: color-mix(in srgb, var(--default-color), transparent 96%);\n  display: flex;\n  align-items: center;\n  padding: 12px 15px;\n  margin-top: 15px;\n  transition: 0.3s;\n}\n\n.details .services-list a:first-child {\n  margin-top: 0;\n}\n\n.details .services-list a i {\n  font-size: 16px;\n  margin-right: 8px;\n  color: var(--accent-color);\n}\n\n.details .services-list a.active {\n  color: var(--contrast-color);\n  background-color: var(--accent-color);\n}\n\n.details .services-list a.active i {\n  color: var(--contrast-color);\n}\n\n.details .services-list a:hover {\n  background-color: color-mix(in srgb, var(--accent-color), transparent 95%);\n  color: var(--accent-color);\n}\n\n.details .download-catalog a {\n  color: var(--default-color);\n  display: flex;\n  align-items: center;\n  padding: 10px 0;\n  transition: 0.3s;\n  border-top: 1px solid color-mix(in srgb, var(--default-color), transparent 90%);\n}\n\n.details .download-catalog a:first-child {\n  border-top: 0;\n  padding-top: 0;\n}\n\n.details .download-catalog a:last-child {\n  padding-bottom: 0;\n}\n\n.details .download-catalog a i {\n  font-size: 24px;\n  margin-right: 8px;\n  color: var(--accent-color);\n}\n\n.details .download-catalog a:hover {\n  color: var(--accent-color);\n}\n\n.details .help-box {\n  background-color: var(--accent-color);\n  color: var(--contrast-color);\n  margin-top: 30px;\n  padding: 30px 15px;\n    box-shadow: 0px 2px 20px rgba(0, 0, 0, 0.1);\n    border-radius: 0.5rem;\n}\n\n.details .help-box .help-icon {\n  font-size: 48px;\n}\n\n.details .help-box h4,\n.details .help-box a {\n  color: var(--contrast-color);\n}\n\n.details .services-img {\n  margin-bottom: 20px;\n\n}\n\n.details .post-img:hover img, .news img:hover {\n\t\ttransform: scale(1.2);\ntransition: all 0.5s;\n}\n\n.details h3 {\n  font-size: 26px;\n  font-weight: 700;\n}\n\n.details p {\n  font-size: 15px;\n}\n\n.details ul {\n  list-style: none;\n  padding: 0;\n  font-size: 15px;\n}\n\n.details ul li {\n  padding: 5px 0;\n  display: flex;\n  align-items: center;\n}\n\n.details ul i {\n  font-size: 20px;\n  margin-right: 8px;\n  color: var(--accent-color);\n}\n\n/*--------------------------------------------------------------\n# Starter Section Section\n--------------------------------------------------------------*/\n.starter-section {\n  /* Add your styles here */\n}\n\n/*--------------------------------------------------------------\n# Services Section\n--------------------------------------------------------------*/\n.services .img {\n  border-radius: 8px;\n  overflow: hidden;\n}\n\n.services .img img {\n  transition: 0.6s;\n}\n\n.services .details {\n  background: color-mix(in srgb, var(--surface-color), transparent 5%);\n  position: absolute;\n  left: 20px;\n  right: 20px;\n  bottom: 20px;\n  padding: 30px;\n  transition: all ease-in-out 0.3s;\n  text-align: center;\n  border-radius: 8px;\n  box-shadow: 0px 0 25px rgba(0, 0, 0, 0.1);\n}\n\n.services .details h3 {\n  font-weight: 700;\n  margin: 10px 0 15px 0;\n  font-size: 22px;\n  transition: ease-in-out 0.3s;\n}\n\n.services .details p {\n  color: color-mix(in srgb, var(--default-color), transparent 10%);\n  line-height: 24px;\n  font-size: 14px;\n  margin-bottom: 0;\n}\n\n.services .service-item:hover .details h3 {\n  color: var(--accent-color);\n}\n\n.services .service-item:hover img {\n  transform: scale(1.2);\n}\n\n/*--------------------------------------------------------------\n# Team Section\n--------------------------------------------------------------*/\n.team .member {\n  position: relative;\n}\n\n.team .member .member-img {\n  overflow: hidden;\n  position: relative;\n  text-align: center;\n\ttransition: transform 0.3s ease; /* \u5e73\u6ed1\u7684\u53d8\u6362\u6548\u679c */\n}\n\n.team .member .member-img:hover {\n  transform: scale(1.1); /* \u9f20\u6807\u60ac\u505c\u65f6\u653e\u592710% */\n}\n\n@media (max-width: 1024px) {\n  .team .member .member-img {\n    margin: 0 60px;\n  }\n}\n\n.team .member .member-img img {\n  position: relative;\n  z-index: 1;\n  width: 200px;\n  height: 250px;\n}\n\n.team .member .member-img .social {\n  position: absolute;\n  inset: 0;\n  background-color: rgba(0, 0, 0, 0.6);\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  z-index: 2;\n  padding-bottom: 20px;\n  transition: 0.3s;\n  visibility: hidden;\n  opacity: 0;\n}\n\n.team .member .member-img .social a {\n  transition: 0.3s;\n  color: var(--contrast-color);\n  font-size: 20px;\n  margin: 0 8px;\n}\n\n.team .member .member-img .social a:hover {\n  color: var(--accent-color);\n}\n\n.team .member .member-info {\n  margin-top: 30px;\n}\n\n.team .member .member-info h4 {\n  font-weight: 700;\n  margin-bottom: 6px;\n  font-size: 18px;\n}\n\n.team .member .member-info span {\n  font-style: italic;\n  display: block;\n  font-size: 15px;\n  color: color-mix(in srgb, var(--default-color), transparent 10%);\n  margin-bottom: 10px;\n}\n\n.team .member .member-info p {\n  margin-bottom: 0;\n  font-size: 14px;\n}\n\n.team .member:hover .member-img .social {\n  padding-bottom: 0;\n  visibility: visible;\n  opacity: 1;\n}\n\n/*--------------------------------------------------------------\n# Blog Posts Section\n--------------------------------------------------------------*/\n.news article {\n  background-color: var(--surface-color);\n  box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);\n  padding: 30px;\n  height: 100%;\n  border-radius: 10px;\n  overflow: hidden;\n}\n\n.news .post-img {\n  max-height: 240px;\n  margin: -30px -30px 15px -30px;\n  overflow: hidden;\n}\n\n.news .post-category {\n  font-size: 16px;\n  color: color-mix(in srgb, var(--default-color), transparent 40%);\n  margin-bottom: 10px;\n}\n\n.news .title {\n  font-size: 20px;\n  font-weight: 700;\n  padding: 0;\n  margin: 0 0 20px 0;\n}\n\n.news .title a {\n  color: var(--heading-color);\n  transition: 0.3s;\n}\n\n.news .title a:hover {\n  color: var(--accent-color);\n}\n\n.news .post-author-img {\n  width: 50px;\n  border-radius: 50%;\n  margin-right: 15px;\n}\n\n.news .post-author {\n  font-weight: 600;\n  margin-bottom: 5px;\n}\n\n.news .post-date {\n  font-size: 14px;\n  color: color-mix(in srgb, var(--default-color), transparent 40%);\n  margin-bottom: 0;\n}\n\n/*--------------------------------------------------------------\n# Blog Pagination Section\n--------------------------------------------------------------*/\n.blog-pagination {\n  padding-top: 0;\n  color: color-mix(in srgb, var(--default-color), transparent 40%);\n}\n\n.blog-pagination ul {\n  display: flex;\n  padding: 0;\n  margin: 0;\n  list-style: none;\n}\n\n.blog-pagination li {\n  margin: 0 5px;\n  transition: 0.3s;\n}\n\n.blog-pagination li a {\n  color: var(--accent-color);\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  width: 36px;\n  height: 36px;\n  border-radius: 50%;\n  border: 1px solid var(--accent-color);\n}\n\n.blog-pagination li a.active,\n.blog-pagination li a:hover {\n  background: var(--accent-color);\n  color: var(--contrast-color);\n}\n\n.blog-pagination li a.active a,\n.blog-pagination li a:hover a {\n  color: var(--contrast-color);\n}\n\n/*--------------------------------------------------------------\n# Blog Details Section\n--------------------------------------------------------------*/\n.blog-details {\n  padding-bottom: 30px;\n}\n\n.blog-details .article {\n  background-color: var(--surface-color);\n  padding: 30px;\n  box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);\n}\n\n.blog-details .post-img {\n  margin: -30px -30px 20px -30px;\n  overflow: hidden;\n}\n\n.blog-details .title {\n  color: var(--heading-color);\n  font-size: 28px;\n  font-weight: 700;\n  padding: 0;\n  margin: 30px 0;\n}\n\n.blog-details .content {\n  margin-top: 20px;\n}\n\n.blog-details .content h3 {\n  font-size: 22px;\n  margin-top: 30px;\n  font-weight: bold;\n}\n\n.blog-details .content blockquote {\n  overflow: hidden;\n  background-color: color-mix(in srgb, var(--default-color), transparent 95%);\n  padding: 60px;\n  position: relative;\n  text-align: center;\n  margin: 20px 0;\n}\n\n.blog-details .content blockquote p {\n  color: var(--default-color);\n  line-height: 1.6;\n  margin-bottom: 0;\n  font-style: italic;\n  font-weight: 500;\n  font-size: 22px;\n}\n\n.blog-details .content blockquote:after {\n  content: \"\";\n  position: absolute;\n  left: 0;\n  top: 0;\n  bottom: 0;\n  width: 3px;\n  background-color: var(--accent-color);\n  margin-top: 20px;\n  margin-bottom: 20px;\n}\n\n.blog-details .meta-top {\n  margin-top: 20px;\n  color: color-mix(in srgb, var(--default-color), transparent 40%);\n}\n\n.blog-details .meta-top ul {\n  display: flex;\n  flex-wrap: wrap;\n  list-style: none;\n  align-items: center;\n  padding: 0;\n  margin: 0;\n}\n\n.blog-details .meta-top ul li+li {\n  padding-left: 20px;\n}\n\n.blog-details .meta-top i {\n  font-size: 16px;\n  margin-right: 8px;\n  line-height: 0;\n  color: color-mix(in srgb, var(--default-color), transparent 40%);\n}\n\n.blog-details .meta-top a {\n  color: color-mix(in srgb, var(--default-color), transparent 40%);\n  font-size: 14px;\n  display: inline-block;\n  line-height: 1;\n}\n\n.blog-details .meta-bottom {\n  padding-top: 10px;\n  border-top: 1px solid color-mix(in srgb, var(--default-color), transparent 90%);\n}\n\n.blog-details .meta-bottom i {\n  color: color-mix(in srgb, var(--default-color), transparent 40%);\n  display: inline;\n}\n\n.blog-details .meta-bottom a {\n  color: color-mix(in srgb, var(--default-color), transparent 40%);\n  transition: 0.3s;\n}\n\n.blog-details .meta-bottom a:hover {\n  color: var(--accent-color);\n}\n\n.blog-details .meta-bottom .cats {\n  list-style: none;\n  display: inline;\n  padding: 0 20px 0 0;\n  font-size: 14px;\n}\n\n.blog-details .meta-bottom .cats li {\n  display: inline-block;\n}\n\n.blog-details .meta-bottom .tags {\n  list-style: none;\n  display: inline;\n  padding: 0;\n  font-size: 14px;\n}\n\n.blog-details .meta-bottom .tags li {\n  display: inline-block;\n}\n\n.blog-details .meta-bottom .tags li+li::before {\n  padding-right: 6px;\n  color: var(--default-color);\n  content: \",\";\n}\n\n.blog-details .meta-bottom .share {\n  font-size: 16px;\n}\n\n.blog-details .meta-bottom .share i {\n  padding-left: 5px;\n}\n\n/*--------------------------------------------------------------\n# Contact Section\n--------------------------------------------------------------*/\n.contact .info-item {\n  background-color: var(--surface-color);\n  box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);\n  padding: 24px 0 30px 0;\n}\n\n.contact .info-item i {\n  font-size: 20px;\n  color: var(--accent-color);\n  width: 56px;\n  height: 56px;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  transition: all 0.3s ease-in-out;\n  border-radius: 50%;\n  border: 2px dotted color-mix(in srgb, var(--accent-color), transparent 40%);\n}\n\n.contact .info-item h3 {\n  color: color-mix(in srgb, var(--default-color), transparent 20%);\n  font-size: 18px;\n  font-weight: 700;\n  margin: 10px 0;\n}\n\n.contact .info-item p {\n  padding: 0;\n  margin-bottom: 0;\n  font-size: 14px;\n}\n\n.contact .php-email-form {\n  background-color: var(--surface-color);\n  box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);\n  height: 100%;\n  padding: 30px 30px 0 30px;\n}\n\n@media (max-width: 575px) {\n  .contact .php-email-form {\n    padding: 20px;\n  }\n}\n\n.contact .php-email-form input[type=text],\n.contact .php-email-form input[type=email],\n.contact .php-email-form textarea {\n  font-size: 14px;\n  padding: 10px 15px;\n  box-shadow: none;\n  border-radius: 0;\n  color: var(--default-color);\n  background-color: var(--surface-color);\n  border-color: color-mix(in srgb, var(--default-color), transparent 80%);\n}\n\n.contact .php-email-form input[type=text]:focus,\n.contact .php-email-form input[type=email]:focus,\n.contact .php-email-form textarea:focus {\n  border-color: var(--accent-color);\n}\n\n.contact .php-email-form input[type=text]::placeholder,\n.contact .php-email-form input[type=email]::placeholder,\n.contact .php-email-form textarea::placeholder {\n  color: color-mix(in srgb, var(--default-color), transparent 70%);\n}\n\n.contact .php-email-form button[type=submit] {\n  color: var(--contrast-color);\n  background: var(--accent-color);\n  border: 0;\n  padding: 10px 30px;\n  transition: 0.4s;\n  border-radius: 50px;\n}\n\n.contact .php-email-form button[type=submit]:hover {\n  background: color-mix(in srgb, var(--accent-color), transparent 20%);\n}\n\n/*--------------------------------------------------------------\n# Widgets\n--------------------------------------------------------------*/\n.widgets-container {\n  background-color: var(--surface-color);\n  padding: 30px;\n  margin: 60px 0 30px 0;\n  box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);\n}\n\n.widget-title {\n  color: var(--heading-color);\n  font-size: 20px;\n  font-weight: 700;\n  padding: 0;\n  margin: 0 0 20px 0;\n}\n\n.widget-item {\n  margin-bottom: 40px;\n}\n\n.widget-item:last-child {\n  margin-bottom: 0;\n}\n\n.blog-author-widget img {\n  max-width: 160px;\n}\n\n.blog-author-widget h4 {\n  font-weight: 600;\n  font-size: 24px;\n  margin: 15px 0 0 0;\n  padding: 0;\n  color: color-mix(in srgb, var(--default-color), transparent 20%);\n}\n\n.blog-author-widget .social-links {\n  margin: 5px 0;\n}\n\n.blog-author-widget .social-links a {\n  color: color-mix(in srgb, var(--default-color), transparent 60%);\n  margin: 0 3px;\n  font-size: 18px;\n}\n\n.blog-author-widget .social-links a:hover {\n  color: var(--accent-color);\n}\n\n.blog-author-widget p {\n  font-style: italic;\n  color: color-mix(in srgb, var(--default-color), transparent 30%);\n  margin: 10px 0 0 0;\n}\n\n.search-widget form {\n  background: var(--background-color);\n  border: 1px solid color-mix(in srgb, var(--default-color), transparent 75%);\n  padding: 3px 10px;\n  position: relative;\n  border-radius: 50px;\n  transition: 0.3s;\n}\n\n.search-widget form input[type=text] {\n  border: 0;\n  padding: 4px 10px;\n  border-radius: 4px;\n  width: calc(100% - 40px);\n  background-color: var(--background-color);\n  color: var(--default-color);\n}\n\n.search-widget form input[type=text]:focus {\n  outline: none;\n}\n\n.search-widget form button {\n  background: none;\n  color: var(--default-color);\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  border: 0;\n  font-size: 16px;\n  padding: 0 16px;\n  transition: 0.3s;\n  line-height: 0;\n}\n\n.search-widget form button i {\n  line-height: 0;\n}\n\n.search-widget form button:hover {\n  color: var(--accent-color);\n}\n\n.search-widget form:is(:focus-within) {\n  border-color: var(--accent-color);\n}\n\n.categories-widget ul {\n  list-style: none;\n  padding: 0;\n  margin: 0;\n}\n\n.categories-widget ul li {\n  padding-bottom: 10px;\n}\n\n.categories-widget ul li:last-child {\n  padding-bottom: 0;\n}\n\n.categories-widget ul a {\n  color: color-mix(in srgb, var(--default-color), transparent 20%);\n  transition: 0.3s;\n}\n\n.categories-widget ul a:hover {\n  color: var(--accent-color);\n}\n\n.categories-widget ul a span {\n  padding-left: 5px;\n  color: color-mix(in srgb, var(--default-color), transparent 50%);\n  font-size: 14px;\n}\n\n.recent-posts-widget .post-item {\n  display: flex;\n  margin-bottom: 15px;\n}\n\n.recent-posts-widget .post-item:last-child {\n  margin-bottom: 0;\n}\n\n.recent-posts-widget .post-item img {\n  width: 80px;\n  margin-right: 15px;\n}\n\n.recent-posts-widget .post-item h4 {\n  font-size: 15px;\n  font-weight: bold;\n  margin-bottom: 5px;\n}\n\n.recent-posts-widget .post-item h4 a {\n  color: var(--default-color);\n  transition: 0.3s;\n}\n\n.recent-posts-widget .post-item h4 a:hover {\n  color: var(--accent-color);\n}\n\n.recent-posts-widget .post-item time {\n  display: block;\n  font-style: italic;\n  font-size: 14px;\n  color: color-mix(in srgb, var(--default-color), transparent 50%);\n}\n\n.tags-widget ul {\n  list-style: none;\n  padding: 0;\n  margin: 0;\n}\n\n.tags-widget ul li {\n  display: inline-block;\n}\n\n.tags-widget ul a {\n  background-color: color-mix(in srgb, var(--default-color), transparent 94%);\n  color: color-mix(in srgb, var(--default-color), transparent 30%);\n  border-radius: 50px;\n  font-size: 14px;\n  padding: 5px 15px;\n  margin: 0 6px 8px 0;\n  display: inline-block;\n  transition: 0.3s;\n}\n\n.tags-widget ul a:hover {\n  background: var(--accent-color);\n  color: var(--contrast-color);\n}\n\n.tags-widget ul a span {\n  padding-left: 5px;\n  color: color-mix(in srgb, var(--default-color), transparent 60%);\n  font-size: 14px;\n}\n\n/* <!-- Tabs --> */\n.tabs {\n  overflow: hidden;\n}\n\n.tabs .nav-tabs {\n  border: 0;\n}\n\n.tabs .nav-link {\n  border: 0;\n  padding: 1.5rem;\n  transition: 0.3s;\n  color: var(--default-color);\n  border-radius: 0;\n  border-right: 2px solid color-mix(in srgb, var(--default-color), transparent 90%);\n  font-weight: 600;\n  font-size: 1.2rem;\n\tbackground: #e6f2fb;\n  margin: 1rem 0;\n    display: flex\n;\n    justify-content: start;\n    align-items: center;\n\n}\n\n.catalog-children a {\n\n\n}\n\n.tabs .nav-link:hover {\n  color: var(--accent-color);\n}\n\n.tabs .nav-link.active {\n  color: white;\n  border-color: var(--accent-color);\n  //background-color: var(--background-color); \n\nbackground-color: #007bc4;\n    \n}\n\n.tabs .nav-link.active::before {\n\tbackground-image: url(https://assets.xammyy.com.cn/xmmyy/resources/image/2025/02/23/647816585080901.png) !important;\n}\n\n.tabs .tab-pane.active {\n  animation: fadeIn 0.5s ease-out;\n}\n\n.tabs .details h3 {\n  font-size: 26px;\n  font-weight: 600;\n  margin: 1rem;\n}\n\n.tabs .details p {\n  color: color-mix(in srgb, var(--default-color), transparent 20%);\n}\n\n.tabs .details p:last-child {\n  margin-bottom: 0;\n}\n\n.tabs .section-title {\n\tpadding-bottom: 0 !important;\n}\n\n@media (max-width: 992px) {\n  .tabs .nav-link {\n    border: 0;\n    padding: 15px;\n  }\n\n  .tabs .nav-link.active {\n    //color: var(--accent-color);\n\t\tcolor: white;\n    background: var(--accent-color);\n  }\n\n\t.col .catalog-children .mgl-list-group {\n\t\tflex: 1 !important;\n\t}\n\n.col-6 {\n    flex: 0 0 auto !important;\n    width: 50%  !important;\n}\n\n.tabs .nav-tabs {\n    border: 0;\n    display: flex\n;\n    flex-wrap: wrap;\n}\n\n.tabs .nav-tabs li {\n\t\tflex: 1;\n}\n\n}\n\n.blockquote::before {\n\t\tcontent: \"\",   \n    border-radius: 4px;\n    border-left: 5px solid var(--accent-color); \n}\n\n.article img {\n\tmax-width: 100%;\n\tmax-height: 100%;\n}\n\n.text-right {\n\ttext-align: right;\n}\n\n.people-swi img {\n\t//height: 156px;\n\t//width: 116px;\n  //  height: 268.965517241px;\n    width: 200px;\n}\n.people-swi span {\n    //color: white;\n    font-size: 1rem;\n    max-width: 100%;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n\t\toverflow: hidden;\n\t\tmargin-left: 1rem;\n}\n.people-swi a {\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n\t\tmax-width: 100%;\n\t\t//color: white;\n}\n\n.white-module .module-title  {\n\tcolor: black !important;\n}\n\n.people-swi h4 {\n    display: flex;\n    flex-direction: column;\n\t\tmax-width: 100%;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n\t\ttext-align: center;padding: 1rem 0;\n\t\toverflow: hidden;\n}\n\n.module-bg {\n\t//background: #ffffff;\n\t//background-image: url(https://assets.xammyy.com.cn/xmmyy/resources/image/2025/02/20/646807593668677.jpg) \n\tbackground-repeat: no-repeat;\n  background-size: cover;\n}\n\n.module-title {\n\tdisplay: flex;\n\t//color: white;\n  align-items: center;\n}\n.module-title::before {\n  content: \"\";\n  background-image: url('https://assets.xammyy.com.cn/xmmyy/resources/image/2025/02/25/648611323445317.png');\n  background-size: contain;\n  background-repeat: no-repeat;\n  width: 4rem; \n  height: 3rem; \n  margin-right: 8px; \n  display: inline-block;\n  vertical-align: bottom;\n}\n\n.active .line-title::before {\n\tbackground-image: url(https://assets.xammyy.com.cn/xmmyy/resources/image/2025/02/23/647816585080901.png) !important;\n}\n\n.line-title::before {\n\n  content: \"\";\n  background-image: url('https://assets.xammyy.com.cn/xmmyy/resources/image/2025/02/23/647822102929477.png');\n  background-size: contain;\n  background-repeat: no-repeat;\n  width: 3rem; \n  height: 2rem;   \n  display: inline-block;\n\n    vertical-align: bottom;\n}\n";
            String js = "function test() { console.log('Hello'); }";
            String html = "<html> <head> <title> Test </title> </head> <body> <h1> Hello </h1> </body> </html>";
            System.out.println("Minified CSS:\n" + MGL_MinifierUtils.minifyContent(css, "css"));
            System.out.println("Minified JS:\n" + MGL_MinifierUtils.minifyContent(js, "js"));
            System.out.println("Minified HTML:\n" + MGL_MinifierUtils.minifyContent(html, "html"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        MGL_MinifierUtils.checkNodeAvailability();
    }
}

