/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGL_JsonUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MGL_JsonUtils.class.getSimpleName());
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> String toJson(T obj) {
        String json = null;
        if (obj != null) {
            try {
                json = mapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return json;
    }

    public static <T> T parse(String json, Class<T> clazz) {
        return MGL_JsonUtils.parse(json, clazz, null);
    }

    public static <T> T parseString(String json, Class<T> clazz, PropertyNamingStrategy strategy) {
        mapper.setPropertyNamingStrategy(strategy);
        return MGL_JsonUtils.parse(json, clazz, null);
    }

    public static <T> T parse(String json, TypeReference type) {
        return MGL_JsonUtils.parse(json, null, type);
    }

    private static <T> T parse(String json, Class<T> clazz, TypeReference type) {
        Object obj = null;
        if (!StringUtils.isBlank((CharSequence)json)) {
            try {
                obj = clazz != null ? mapper.readValue(json, clazz) : mapper.readValue(json, type);
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return (T)obj;
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new JavaTimeModule());
    }
}

