/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils.http;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import tech.mgl.core.utils.http.MGLRequestCallBack;

public class MGL_UploadBuilder {
    private final String uploadUrl;
    private final File file;
    private final Map<String, String> headers;
    private final Map<String, String> additionalParams;
    private final String fileParamName;
    private final String fileType;
    private final MGLRequestCallBack callBack;

    private MGL_UploadBuilder(Builder builder) {
        this.uploadUrl = builder.uploadUrl;
        this.file = builder.file;
        this.headers = builder.headers;
        this.additionalParams = builder.additionalParams;
        this.fileParamName = builder.fileParamName;
        this.fileType = builder.fileType;
        this.callBack = builder.callBack;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public File getFile() {
        return this.file;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getAdditionalParams() {
        return this.additionalParams;
    }

    public String getFileParamName() {
        return this.fileParamName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public MGLRequestCallBack getCallBack() {
        return this.callBack;
    }

    public static void main(String[] args) {
        MGL_UploadBuilder uploadBuilder = new Builder().uploadUrl("https://example.com/upload").file(new File("path/to/file.txt")).fileParamName("uploadFile").fileType("image/png").build();
        System.out.println("Upload URL: " + uploadBuilder.getUploadUrl());
        System.out.println("File: " + uploadBuilder.getFile().getPath());
        System.out.println("File Param Name: " + uploadBuilder.getFileParamName());
        System.out.println("File Type: " + uploadBuilder.getFileType());
    }

    public static class Builder {
        private String uploadUrl;
        private File file;
        private Map<String, String> headers = new HashMap<String, String>();
        private Map<String, String> additionalParams = new HashMap<String, String>();
        private String fileParamName = "file";
        private String fileType = "application/octet-stream";
        private MGLRequestCallBack callBack;

        public Builder uploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
            return this;
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder additionalParams(Map<String, String> additionalParams) {
            this.additionalParams = additionalParams;
            return this;
        }

        public Builder fileParamName(String fileParamName) {
            this.fileParamName = fileParamName;
            return this;
        }

        public Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public Builder callBack(MGLRequestCallBack callBack) {
            this.callBack = callBack;
            return this;
        }

        public MGL_UploadBuilder build() {
            return new MGL_UploadBuilder(this);
        }
    }
}

