/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;

public class MGL_NetUtils {
    public static boolean download(String fileUrl, String savePath) {
        boolean bl;
        block8: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                HttpGet request = new HttpGet(fileUrl);
                bl = (Boolean)httpClient.execute((ClassicHttpRequest)request, response1 -> {
                    InputStream inputStream = response1.getEntity().getContent();
                    Path saveFilePath = Path.of(savePath, new String[0]);
                    Files.createDirectories(saveFilePath.getParent(), new FileAttribute[0]);
                    Files.copy(inputStream, saveFilePath, StandardCopyOption.REPLACE_EXISTING);
                    System.out.println("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\uff1a" + savePath);
                    return true;
                });
                if (httpClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + e.getMessage());
                    return false;
                }
            }
            httpClient.close();
        }
        return bl;
    }

    public static String uploadFile(String uploadUrl, File file) {
        if (!file.exists()) {
            return "\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + file.getAbsolutePath();
        }
        HashMap<String, Object> objectObjectHashMap = new HashMap<String, Object>();
        objectObjectHashMap.put("file", file);
        return MGL_NetUtils.upload(uploadUrl, objectObjectHashMap);
    }

    public static String upload(String uploadUrl, Map<String, Object> params) {
        String string;
        block14: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                HttpPost uploadRequest = new HttpPost(uploadUrl);
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                if (params != null) {
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        Object value = entry.getValue();
                        String key = entry.getKey();
                        if (value instanceof File) {
                            File file = (File)value;
                            if (!file.isFile() || !file.exists()) continue;
                            builder.addBinaryBody(key, file, ContentType.DEFAULT_BINARY, file.getName());
                            continue;
                        }
                        if (value instanceof InputStream) {
                            InputStream inputStream = (InputStream)value;
                            builder.addBinaryBody(key, inputStream, ContentType.DEFAULT_BINARY, key);
                            continue;
                        }
                        if (value instanceof String) {
                            String s = (String)value;
                            builder.addTextBody(key, s, ContentType.DEFAULT_TEXT);
                            continue;
                        }
                        if (value instanceof Path) {
                            Path filePath = (Path)value;
                            builder.addBinaryBody(key, filePath.toFile(), ContentType.DEFAULT_BINARY, filePath.getFileName().toString());
                            continue;
                        }
                        if (value == null) continue;
                        builder.addPart(key, (ContentBody)new StringBody(value.toString(), ContentType.APPLICATION_FORM_URLENCODED));
                    }
                }
                HttpEntity entity = builder.build();
                uploadRequest.setEntity(entity);
                URI uri = new URI(uploadUrl);
                HttpHost targetHost = new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort());
                HttpContext context = null;
                HttpClientResponseHandler responseHandler = response -> {
                    if (response.getEntity() != null) {
                        return EntityUtils.toString((HttpEntity)response.getEntity());
                    }
                    return "No response content";
                };
                string = (String)httpClient.execute(targetHost, (ClassicHttpRequest)uploadRequest, context, responseHandler);
                if (httpClient == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 \uff1a " + e.getMessage();
                }
            }
            httpClient.close();
        }
        return string;
    }

    public static void main(String[] args) {
        String fileUrl = "https://youjia.cdn.bcebos.com/wenda_pics/16602066641635764ec9.png@!default_youjia";
        String savePath = "downloads/sample.jpg";
        boolean success = MGL_NetUtils.download(fileUrl, savePath);
        System.out.println("\u4e0b\u8f7d\u6210\u529f\uff1a" + success);
    }
}

