/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionSpec;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.TlsVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_StringUtils;
import tech.mgl.core.utils.http.MGLRequestCallBack;
import tech.mgl.utils.http.MGL_HttpRequest;
import tech.mgl.utils.http.MGL_UploadBuilder;

public class MGL_HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MGL_HttpUtils.class.getSimpleName());

    public static void main(String[] args) throws IOException {
        String s = MGL_HttpUtils.post("https://123456.blog", null);
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String access(String url, Map<String, Object> params, Map<String, String> header, String encode) throws Exception {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new NullPointerException("URL \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)encode)) {
            encode = "UTF-8";
        }
        String content = "-1";
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse response = null;
        try {
            if (url.toLowerCase().startsWith("https")) {
                closeableHttpClient = MGL_HttpUtils.createSSLClientDefault();
                logger.info("ssl---");
            } else {
                logger.info("default---");
                closeableHttpClient = HttpClients.createDefault();
            }
            HttpPost post = new HttpPost(url);
            post.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            if (header != null && !header.isEmpty()) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    post.setHeader(entry.getKey(), (Object)entry.getValue());
                }
            }
            RequestConfig.Builder conBd = RequestConfig.custom();
            post.setConfig(conBd.build());
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    if (entry.getValue() instanceof Map) {
                        MGL_HttpUtils.setMapParams(post, entry.getValue());
                        continue;
                    }
                    formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
                }
                UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(formParams, StandardCharsets.UTF_8);
                post.setEntity((HttpEntity)postEntity);
            }
            response = (CloseableHttpResponse)closeableHttpClient.execute((ClassicHttpRequest)post, classicHttpResponse -> {
                System.out.println(classicHttpResponse.getCode());
                return null;
            });
            post = null;
            HttpEntity receiveEntity = response.getEntity();
            if (receiveEntity != null) {
                content = EntityUtils.toString((HttpEntity)receiveEntity, (String)encode);
                receiveEntity = null;
            }
        }
        finally {
            if (response != null) {
                response.close();
                response = null;
            }
            if (closeableHttpClient != null) {
                closeableHttpClient.close();
                closeableHttpClient = null;
            }
        }
        return content;
    }

    private static void setMapParams(HttpPost post, Object obj) throws UnsupportedEncodingException {
        Map entityStream = (Map)obj;
        if (entityStream != null && !entityStream.isEmpty() && entityStream.size() > 0) {
            for (Map.Entry ent : entityStream.entrySet()) {
                if (ent == null || !StringUtils.isNotBlank((CharSequence)((CharSequence)ent.getKey())) || !"json".equalsIgnoreCase((String)ent.getKey()) && !"xml".equalsIgnoreCase((String)ent.getKey())) continue;
                StringEntity sentity = new StringEntity(((String)ent.getValue()).toString());
                post.setEntity((HttpEntity)sentity);
            }
        }
    }

    private static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext);
            PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return HttpClients.createDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String access_with_ssl(String url, Map<String, Object> params) throws Exception {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new NullPointerException("URL \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String encode = "UTF-8";
        if (StringUtils.isBlank((CharSequence)encode)) {
            encode = "UTF-8";
        }
        String content = "-1";
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse response = null;
        try {
            closeableHttpClient = MGL_HttpUtils.createSSLClientDefault();
            HttpPost post = new HttpPost(url);
            post.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded; charset=utf-8");
            RequestConfig.Builder conBd = RequestConfig.custom();
            post.setConfig(conBd.build());
            if (params != null && !params.isEmpty() && params.size() > 0) {
                Object object;
                Map entityStream;
                Map header = (Map)params.get(ParamsKey.HEADER.toString());
                if (header != null && !header.isEmpty() && header.size() > 0) {
                    for (Map.Entry entry : header.entrySet()) {
                        post.setHeader((String)entry.getKey(), entry.getValue());
                    }
                }
                Map ps = (Map)params.get(ParamsKey.HEADER.toString());
                ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                if (ps != null && !ps.isEmpty() && ps.size() > 0) {
                    for (Map.Entry entry : ps.entrySet()) {
                        formParams.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
                    }
                    UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(formParams, StandardCharsets.UTF_8);
                    post.setEntity((HttpEntity)postEntity);
                }
                if ((entityStream = (Map)params.get(ParamsKey.STREAM.toString())) != null && !entityStream.isEmpty()) {
                    for (Map.Entry entry : entityStream.entrySet()) {
                        if (entry == null || !StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey())) || !"json".equalsIgnoreCase((String)entry.getKey()) && !"xml".equalsIgnoreCase((String)entry.getKey())) continue;
                        StringEntity entity = new StringEntity((String)entry.getValue(), StandardCharsets.UTF_8);
                        post.setEntity((HttpEntity)entity);
                    }
                }
                if ((object = params.get(ParamsKey.ENCODE.toString())) != null) {
                    encode = object.toString();
                }
            }
            response = closeableHttpClient.execute((ClassicHttpRequest)post);
            post = null;
            HttpEntity receiveEntity = response.getEntity();
            if (receiveEntity != null) {
                content = EntityUtils.toString((HttpEntity)receiveEntity, (String)encode);
                receiveEntity = null;
            }
        }
        finally {
            if (response != null) {
                response.close();
                response = null;
            }
            if (closeableHttpClient != null) {
                closeableHttpClient.close();
                closeableHttpClient = null;
            }
        }
        return content;
    }

    public static String sendGet(String url, Map<String, String> params) throws Exception {
        return MGL_HttpUtils.send(url, params, null, null);
    }

    public static String sendGet(String url) throws Exception {
        return MGL_HttpUtils.send(url, null, null, null);
    }

    public static String sendGet(String url, Map<String, String> params, Map<String, String> header) throws Exception {
        return MGL_HttpUtils.send(url, params, header, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String send(String url, Map<String, String> params, Map<String, String> header, String encode) throws Exception {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new NullPointerException("URL \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)encode)) {
            encode = "UTF-8";
        }
        String content = "-1";
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse response = null;
        try {
            if (url.toLowerCase().startsWith("https")) {
                closeableHttpClient = MGL_HttpUtils.createSSLClientDefault();
                logger.info("ssl---");
            } else {
                logger.info("default---");
                closeableHttpClient = HttpClients.createDefault();
            }
            HttpGet post = new HttpGet(url);
            post.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            if (header != null && !header.isEmpty()) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    post.setHeader(entry.getKey(), (Object)entry.getValue());
                }
            }
            RequestConfig.Builder conBd = RequestConfig.custom();
            post.setConfig(conBd.build());
            response = closeableHttpClient.execute((ClassicHttpRequest)post);
            post = null;
            HttpEntity receiveEntity = response.getEntity();
            if (receiveEntity != null) {
                content = EntityUtils.toString((HttpEntity)receiveEntity, (String)encode);
                receiveEntity = null;
            }
        }
        finally {
            if (response != null) {
                response.close();
                response = null;
            }
            if (closeableHttpClient != null) {
                closeableHttpClient.close();
                closeableHttpClient = null;
            }
        }
        return content;
    }

    public static String sendPost(String url, Map<String, Object> params) throws Exception {
        return MGL_HttpUtils.access(url, params, null, "UTF-8");
    }

    public static String sendPost(String url) throws Exception {
        return MGL_HttpUtils.access(url, null, null, "UTF-8");
    }

    public static String sendPost(String url, Map<String, Object> params, Map<String, String> header) throws Exception {
        return MGL_HttpUtils.access(url, params, header, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String sendWithDefault(String method, String url, StringBuilder parameter) {
        BufferedReader in = null;
        Object result = "";
        try {
            String line;
            URL urlObj = new URL(url);
            HttpURLConnection httpConn = (HttpURLConnection)urlObj.openConnection();
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);
            httpConn.setRequestMethod(method);
            httpConn.getOutputStream().write(parameter.toString().getBytes("UTF-8"));
            httpConn.getOutputStream().flush();
            httpConn.getOutputStream().close();
            httpConn.getResponseCode();
            in = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = (String)result + "\n" + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static void download(String url, final String path, MGLRequestCallBack back) throws IOException {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().get().url(url).build();
        System.out.println("1111111111");
        if (null != back) {
            client.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }

                public void onResponse(Call call, Response response) {
                    System.out.println("1111111111");
                    InputStream inputStream = response.body().byteStream();
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(new File(path));
                        byte[] buffer = new byte[2048];
                        int len = 0;
                        while ((len = inputStream.read(buffer)) != -1) {
                            fileOutputStream.write(buffer, 0, len);
                        }
                        fileOutputStream.flush();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    logger.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f");
                }
            });
        } else {
            Response response = client.newCall(request).execute();
            System.out.println("1111111333111");
            InputStream inputStream = response.body().byteStream();
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(new File(path));
                byte[] buffer = new byte[2048];
                int len = 0;
                while ((len = inputStream.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, len);
                }
                fileOutputStream.flush();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            logger.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f");
        }
    }

    public static String upload(final MGL_UploadBuilder uploadBuilder) throws IOException {
        OkHttpClient okHttpClient = new OkHttpClient();
        File file = uploadBuilder.getFile();
        MediaType MEDIATYPE = MediaType.parse((String)"text/plain; charset=utf-8");
        RequestBody fileRequestBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)uploadBuilder.getFileType()));
        Request.Builder requestBuilder = new Request.Builder().url(uploadBuilder.getUploadUrl());
        if (MGL_StringUtils.isNotBlank((CharSequence)uploadBuilder.getFileParamName())) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(uploadBuilder.getFileParamName(), file.getName(), fileRequestBody);
            if (uploadBuilder.getAdditionalParams() != null && !uploadBuilder.getAdditionalParams().isEmpty()) {
                for (Map.Entry<String, String> entry : uploadBuilder.getAdditionalParams().entrySet()) {
                    builder.addFormDataPart(entry.getKey(), entry.getValue());
                }
            }
            MultipartBody multipartBody = builder.build();
            requestBuilder.post((RequestBody)multipartBody);
        } else {
            requestBuilder.post(fileRequestBody);
        }
        if (uploadBuilder.getHeaders() != null && !uploadBuilder.getHeaders().isEmpty()) {
            for (Map.Entry entry : uploadBuilder.getHeaders().entrySet()) {
                requestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Request request = requestBuilder.build();
        if (null != uploadBuilder.getCallBack()) {
            okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    uploadBuilder.getCallBack().failure(e);
                }

                public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                    ResponseBody body = response.body();
                    if (null != body) {
                        uploadBuilder.getCallBack().result(body.string());
                        body.close();
                    } else {
                        uploadBuilder.getCallBack().result(null);
                    }
                }
            });
        } else {
            try (Response response = okHttpClient.newCall(request).execute();){
                System.out.println(response.isSuccessful());
                if (response.body() != null) {
                    String string = response.body().string();
                    return string;
                }
            }
        }
        return null;
    }

    public static String get(String url, MGLRequestCallBack back) throws IOException {
        return MGL_HttpUtils.request(url, MGL_HttpRequest.REQUEST_METHOD.GET, null, null, null, null, back);
    }

    public static String get(String url) throws IOException {
        return MGL_HttpUtils.request(url, MGL_HttpRequest.REQUEST_METHOD.GET, null, null, null, null, null);
    }

    public static String post(String url, Map<String, Object> params, InputStream cert, String certPwd, MGLRequestCallBack back) throws IOException {
        return MGL_HttpUtils.request(url, MGL_HttpRequest.REQUEST_METHOD.POST, params, null, cert, certPwd, back);
    }

    public static String post(String url, Map<String, Object> params, Map<String, String> header, InputStream cert, String certPwd, MGLRequestCallBack back) throws IOException {
        return MGL_HttpUtils.request(url, MGL_HttpRequest.REQUEST_METHOD.POST, params, header, cert, certPwd, back);
    }

    public static String post(String url, Map<String, Object> params, MGLRequestCallBack back) throws IOException {
        return MGL_HttpUtils.request(url, MGL_HttpRequest.REQUEST_METHOD.POST, params, null, null, null, back);
    }

    public static String post(String url, Map<String, Object> params) throws IOException {
        return MGL_HttpUtils.request(url, MGL_HttpRequest.REQUEST_METHOD.POST, params, null, null, null, null);
    }

    public static String postJson(String url, Object data) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ParamsType.JSON_STREAM.name(), data);
        return MGL_HttpUtils.request(url, MGL_HttpRequest.REQUEST_METHOD.POST, params, null, null, null, null);
    }

    public static String post(String url, Map<String, Object> params, Map<String, String> header) throws IOException {
        return MGL_HttpUtils.request(url, MGL_HttpRequest.REQUEST_METHOD.POST, params, header, null, null, null);
    }

    public static String upload(String url, Map<String, Object> params) throws IOException {
        return MGL_HttpRequest.builder().setUrl(url).setMethod(MGL_HttpRequest.REQUEST_METHOD.POST).setForm(params).setEnctype(MGL_HttpRequest.EnctypeType.MULTIPART_FORM_DATA).build().request();
    }

    private static OkHttpClient.Builder clientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
        ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
        specs.add(cs);
        specs.add(ConnectionSpec.COMPATIBLE_TLS);
        specs.add(ConnectionSpec.CLEARTEXT);
        builder.connectionSpecs(specs);
        return builder;
    }

    public static String request(String url, MGL_HttpRequest.REQUEST_METHOD rMethod, Map<String, Object> params, Map<String, String> header, InputStream cert, String certPwd, MGLRequestCallBack back) throws IOException {
        return MGL_HttpRequest.builder().setUrl(url).setMethod(rMethod).setForm(params).setHeader(header).setCert(cert).setCertPwd(certPwd).setCallBack(back).build().request();
    }

    public static enum ParamsKey {
        ENCODE,
        HEADER,
        PARAMS,
        STREAM;

    }

    public static enum ParamsType {
        ENCODE,
        HEADER,
        JSON_STREAM,
        XML_STREAM,
        FILE_STREAM,
        FILES_STREAM;

    }
}

