/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.http.MGLRequestCallBack;
import tech.mgl.utils.http.MGL_HttpUtils;

public class MGL_HttpRequest {
    private final Logger logger = LoggerFactory.getLogger((String)MGL_HttpRequest.class.getSimpleName());
    private String url;
    private REQUEST_METHOD method;
    private Map<String, Object> form;
    private Map<String, String> header;
    private EnctypeType enctype = EnctypeType.APPLICATION_X_WWW_FORM_URLENCODED;
    private MGLRequestCallBack callBack;
    private InputStream cert;
    private String certPwd;
    private int connectTimeout = 10;
    private int writeTimeout = 15;
    private int readTimeout = 60;
    public final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    public final MediaType XML = MediaType.get((String)"application/xml; charset=utf-8");

    public MGL_HttpRequest() {
    }

    public MGL_HttpRequest(Builder builder) {
        this.url = builder.getUrl();
        this.method = builder.getMethod();
        this.form = builder.getForm();
        this.header = builder.getHeader();
        this.enctype = builder.getEnctype();
        this.callBack = this.getCallBack();
        this.cert = this.getCert();
        this.certPwd = this.getCertPwd();
        this.connectTimeout = this.getConnectTimeout();
        this.writeTimeout = this.getWriteTimeout();
        this.readTimeout = this.getReadTimeout();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public MGL_HttpRequest setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public MGL_HttpRequest setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public MGL_HttpRequest setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public MGLRequestCallBack getCallBack() {
        return this.callBack;
    }

    public MGL_HttpRequest setCallBack(MGLRequestCallBack callBack) {
        this.callBack = callBack;
        return this;
    }

    public InputStream getCert() {
        return this.cert;
    }

    public MGL_HttpRequest setCert(InputStream cert) {
        this.cert = cert;
        return this;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public MGL_HttpRequest setHeader(Map<String, String> header) {
        this.header = header;
        return this;
    }

    public String getCertPwd() {
        return this.certPwd;
    }

    public MGL_HttpRequest setCertPwd(String certPwd) {
        this.certPwd = certPwd;
        return this;
    }

    public MGL_HttpRequest(String url) {
        this.url = url;
    }

    public String request() throws IOException {
        Request.Builder requestBuilder = new Request.Builder();
        switch (this.getMethod().ordinal()) {
            case 1: {
                if (null != this.form) {
                    RequestBody body;
                    if (this.form.containsKey(MGL_HttpUtils.ParamsType.XML_STREAM.toString())) {
                        body = RequestBody.create((String)this.form.get(MGL_HttpUtils.ParamsType.XML_STREAM.toString()).toString(), (MediaType)this.XML);
                        requestBuilder.post(body).url(this.url);
                        break;
                    }
                    if (this.form.containsKey(MGL_HttpUtils.ParamsType.JSON_STREAM.toString())) {
                        body = RequestBody.create((String)this.form.get(MGL_HttpUtils.ParamsType.JSON_STREAM.toString()).toString(), (MediaType)this.JSON);
                        requestBuilder.post(body).url(this.url);
                        break;
                    }
                    if (EnctypeType.APPLICATION_X_WWW_FORM_URLENCODED == this.getEnctype()) {
                        FormBody.Builder bodyBuilder = new FormBody.Builder();
                        for (Map.Entry<String, Object> entry : this.form.entrySet()) {
                            if (entry.getValue() instanceof File || entry.getValue() instanceof InputStream || MGL_HttpUtils.ParamsType.XML_STREAM.toString().equals(entry.getKey()) || MGL_HttpUtils.ParamsType.JSON_STREAM.toString().equals(entry.getKey())) continue;
                            bodyBuilder.add(entry.getKey(), entry.getValue().toString());
                        }
                        requestBuilder.url(this.url).post((RequestBody)bodyBuilder.build());
                        break;
                    }
                    if (EnctypeType.MULTIPART_FORM_DATA != this.getEnctype()) break;
                    body = new MultipartBody.Builder().setType(MultipartBody.FORM);
                    for (Map.Entry<String, Object> entry : this.form.entrySet()) {
                        if (MGL_HttpUtils.ParamsType.XML_STREAM.toString().equals(entry.getKey()) || MGL_HttpUtils.ParamsType.JSON_STREAM.toString().equals(entry.getKey())) continue;
                        Object object = entry.getValue();
                        if (object instanceof File) {
                            File file = (File)object;
                            RequestBody fileBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)"multipart/form-data;charset=utf-8"));
                            System.out.println(file.getName());
                            body.addFormDataPart(entry.getKey(), file.getName(), fileBody);
                            continue;
                        }
                        this.logger.info(entry.getKey() + "=" + String.valueOf(entry.getValue()));
                        body.addFormDataPart(entry.getKey(), entry.getValue().toString());
                    }
                    requestBuilder.url(this.url).post((RequestBody)body.build());
                    break;
                }
                requestBuilder.url(this.url).post(RequestBody.create((String)"", (MediaType)MediaType.parse((String)"application/text;charset=utf-8")));
                break;
            }
            case 0: {
                Request request = requestBuilder.url(this.url).build();
                HttpUrl.Builder builder = request.url().newBuilder();
                if (null != this.form) {
                    for (Map.Entry<String, Object> entry : this.form.entrySet()) {
                        builder.addQueryParameter(entry.getKey(), (String)entry.getValue());
                    }
                    requestBuilder.url(builder.build());
                    break;
                }
                requestBuilder.url(this.url);
                break;
            }
        }
        if (null != this.header) {
            for (Map.Entry entry : this.header.entrySet()) {
                System.out.println((String)entry.getKey());
                requestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                requestBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.setCertificate(builder, this.cert, this.certPwd);
        builder.cache(null).followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(true).connectTimeout((long)this.connectTimeout, TimeUnit.SECONDS).writeTimeout((long)this.writeTimeout, TimeUnit.SECONDS).readTimeout((long)this.readTimeout, TimeUnit.SECONDS);
        OkHttpClient okHttpClient = builder.build();
        if (null != this.callBack) {
            okHttpClient.newCall(requestBuilder.build()).enqueue(new Callback(){

                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    MGL_HttpRequest.this.logger.error("onFailure:".concat(e.getMessage()), (Throwable)e);
                    call.cancel();
                }

                public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                    MGL_HttpRequest.this.logger.info("onResponse");
                    if (null != response.body()) {
                        MGL_HttpRequest.this.callBack.result(Objects.requireNonNull(response.body()).string());
                    } else {
                        MGL_HttpRequest.this.callBack.result("");
                    }
                    call.cancel();
                }
            });
            return null;
        }
        Call cl = okHttpClient.newCall(requestBuilder.build());
        Response response = cl.execute();
        if (!response.isSuccessful()) {
            this.logger.error("Error Message: {}, {}, {}", new Object[]{response.message(), response.code(), response.body()});
            return null;
        }
        ResponseBody body = response.body();
        if (null == body) {
            this.logger.info("body is null");
            return null;
        }
        String str = body.string();
        response.close();
        cl.cancel();
        return str;
    }

    public String getUrl() {
        return this.url;
    }

    public MGL_HttpRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public REQUEST_METHOD getMethod() {
        return this.method;
    }

    public MGL_HttpRequest setMethod(REQUEST_METHOD method) {
        this.method = method;
        return this;
    }

    public Map<String, Object> getForm() {
        return this.form;
    }

    public MGL_HttpRequest setForm(Map<String, Object> form) {
        this.form = form;
        return this;
    }

    public EnctypeType getEnctype() {
        return this.enctype;
    }

    public MGL_HttpRequest setEnctype(EnctypeType enctype) {
        this.enctype = enctype;
        return this;
    }

    private void setCertificate(OkHttpClient.Builder okHttpClientBuilder, String cerStr) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cerStr.getBytes());
            Certificate ca = certificateFactory.generateCertificate(byteArrayInputStream);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("ca", ca);
            byteArrayInputStream.close();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
            okHttpClientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)tmf.getTrustManagers()[0]);
            okHttpClientBuilder.hostnameVerifier(new HostnameVerifier(this){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setCertificate(OkHttpClient.Builder okHttpClientBuilder, InputStream cert, String certPass) {
        try {
            if (null == cert || StringUtils.isBlank((CharSequence)certPass)) {
                return;
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore clientStore = KeyStore.getInstance("PKCS12");
            if (StringUtils.isNotBlank((CharSequence)certPass)) {
                char[] passArray = certPass.toCharArray();
                clientStore.load(cert, passArray);
                kmf.init(clientStore, passArray);
            } else {
                clientStore.load(cert, null);
                kmf.init(clientStore, null);
            }
            cert.close();
            KeyManager[] kms = kmf.getKeyManagers();
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(kms, null, new SecureRandom());
            okHttpClientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)new MGLX509TrustManager());
            okHttpClientBuilder.hostnameVerifier((hostname, session) -> true);
        }
        catch (IOException | UnrecoverableKeyException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private SSLSocketFactory getSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager[] trustManagers = new TrustManager[]{new MGLX509TrustManager()};
        context.init(null, trustManagers, new SecureRandom());
        return context.getSocketFactory();
    }

    public static enum EnctypeType {
        APPLICATION_X_WWW_FORM_URLENCODED,
        MULTIPART_FORM_DATA,
        TEXT_PALIN;

    }

    public static class Builder {
        private String url;
        private REQUEST_METHOD method;
        private Map<String, Object> form;
        private Map<String, String> header;
        private EnctypeType enctype = EnctypeType.APPLICATION_X_WWW_FORM_URLENCODED;
        private MGLRequestCallBack callBack;
        private InputStream cert;
        private String certPwd;
        private int connectTimeout = 10;
        private int writeTimeout = 15;
        private int readTimeout = 60;

        public String getUrl() {
            return this.url;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public REQUEST_METHOD getMethod() {
            return this.method;
        }

        public Builder setMethod(REQUEST_METHOD method) {
            this.method = method;
            return this;
        }

        public Map<String, Object> getForm() {
            return this.form;
        }

        public Builder setForm(Map<String, Object> form) {
            this.form = form;
            return this;
        }

        public EnctypeType getEnctype() {
            return this.enctype;
        }

        public Builder setEnctype(EnctypeType enctype) {
            this.enctype = enctype;
            return this;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public int getWriteTimeout() {
            return this.writeTimeout;
        }

        public Builder setWriteTimeout(int writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public MGLRequestCallBack getCallBack() {
            return this.callBack;
        }

        public Builder setCallBack(MGLRequestCallBack callBack) {
            this.callBack = callBack;
            return this;
        }

        public InputStream getCert() {
            return this.cert;
        }

        public Builder setCert(InputStream cert) {
            this.cert = cert;
            return this;
        }

        public Map<String, String> getHeader() {
            return this.header;
        }

        public Builder setHeader(Map<String, String> header) {
            this.header = header;
            return this;
        }

        public String getCertPwd() {
            return this.certPwd;
        }

        public Builder setCertPwd(String certPwd) {
            this.certPwd = certPwd;
            return this;
        }

        public MGL_HttpRequest build() {
            return new MGL_HttpRequest(this);
        }
    }

    public static enum REQUEST_METHOD {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        CONNECT,
        OPTIONS,
        TRACE;

    }

    class MGLX509TrustManager
    implements X509TrustManager {
        MGLX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (chain == null) {
                throw new CertificateException("checkServerTrusted: X509Certificate array is null");
            }
            if (chain.length < 1) {
                throw new CertificateException("checkServerTrusted: X509Certificate is empty");
            }
            if (null == authType || !authType.equals("ECDHE_RSA")) {
                throw new CertificateException("checkServerTrusted: AuthType is not ECDHE_RSA");
            }
            try {
                TrustManagerFactory factory = TrustManagerFactory.getInstance("X509");
                factory.init((KeyStore)null);
                for (TrustManager trustManager : factory.getTrustManagers()) {
                    ((X509TrustManager)trustManager).checkServerTrusted(chain, authType);
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                MGL_HttpRequest.this.logger.error(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

