/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils.db;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class MGL_DatabaseTypeMapper {
    private static final Map<String, Class<?>> dbTypeToJavaTypeMap = new HashMap();

    public static Class<?> getJavaType(String dbType, DbVendor dbVendor) {
        if (dbVendor == null) {
            throw new IllegalArgumentException("Database vendor cannot be null");
        }
        dbType = dbType.toUpperCase();
        return switch (dbVendor.ordinal()) {
            case 0 -> dbTypeToJavaTypeMap.getOrDefault(dbType, Object.class);
            case 3 -> MGL_DatabaseTypeMapper.getPostgresType(dbType);
            case 1 -> MGL_DatabaseTypeMapper.getOracleType(dbType);
            case 2 -> MGL_DatabaseTypeMapper.getMSSQLServerType(dbType);
            default -> throw new IllegalArgumentException("Unsupported database vendor: " + String.valueOf((Object)dbVendor));
        };
    }

    private static Class<?> getPostgresType(String dbType) {
        return switch (dbType.toUpperCase()) {
            case "INTEGER", "INT4" -> Integer.class;
            case "BIGINT", "INT8" -> Long.class;
            case "SMALLINT" -> Short.class;
            case "REAL" -> Float.class;
            case "DOUBLE PRECISION" -> Double.class;
            case "NUMERIC", "DECIMAL" -> BigDecimal.class;
            case "CHAR", "VARCHAR", "TEXT" -> String.class;
            case "DATE" -> Date.class;
            case "TIMESTAMP" -> Timestamp.class;
            case "TIMESTAMPTZ" -> Timestamp.class;
            case "BOOLEAN", "BOOL" -> Boolean.class;
            case "BYTEA" -> byte[].class;
            case "UUID" -> UUID.class;
            default -> Object.class;
        };
    }

    private static Class<?> getOracleType(String dbType) {
        return switch (dbType) {
            case "NUMBER" -> Long.class;
            case "VARCHAR2", "CHAR" -> String.class;
            case "DATE" -> Date.class;
            case "TIMESTAMP" -> Timestamp.class;
            case "CLOB" -> String.class;
            case "BLOB" -> byte[].class;
            case "FLOAT" -> Float.class;
            case "DOUBLE" -> Double.class;
            default -> Object.class;
        };
    }

    private static Class<?> getMSSQLServerType(String dbType) {
        return switch (dbType) {
            case "INT" -> Integer.class;
            case "TINYINT" -> Byte.class;
            case "SMALLINT" -> Short.class;
            case "BIGINT" -> Long.class;
            case "FLOAT" -> Float.class;
            case "REAL" -> Double.class;
            case "DECIMAL", "NUMERIC" -> BigDecimal.class;
            case "VARCHAR", "TEXT", "CHAR" -> String.class;
            case "DATETIME", "SMALLDATETIME" -> Timestamp.class;
            case "BIT" -> Boolean.class;
            case "BINARY", "VARBINARY" -> byte[].class;
            default -> Object.class;
        };
    }

    public static void main(String[] args) {
        System.out.println(MGL_DatabaseTypeMapper.getJavaType("VARCHAR", DbVendor.MYSQL));
        System.out.println(MGL_DatabaseTypeMapper.getJavaType("NUMERIC", DbVendor.POSTGRESQL));
        System.out.println(MGL_DatabaseTypeMapper.getJavaType("CLOB", DbVendor.ORACLE));
        System.out.println(MGL_DatabaseTypeMapper.getJavaType("DECIMAL", DbVendor.SQLSERVER));
    }

    static {
        dbTypeToJavaTypeMap.put("INT", Integer.class);
        dbTypeToJavaTypeMap.put("TINYINT", Byte.class);
        dbTypeToJavaTypeMap.put("SMALLINT", Short.class);
        dbTypeToJavaTypeMap.put("BIGINT", Long.class);
        dbTypeToJavaTypeMap.put("FLOAT", Float.class);
        dbTypeToJavaTypeMap.put("DOUBLE", Double.class);
        dbTypeToJavaTypeMap.put("DECIMAL", BigDecimal.class);
        dbTypeToJavaTypeMap.put("CHAR", String.class);
        dbTypeToJavaTypeMap.put("VARCHAR", String.class);
        dbTypeToJavaTypeMap.put("TEXT", String.class);
        dbTypeToJavaTypeMap.put("DATE", Date.class);
        dbTypeToJavaTypeMap.put("DATETIME", Timestamp.class);
        dbTypeToJavaTypeMap.put("TIMESTAMP", Timestamp.class);
        dbTypeToJavaTypeMap.put("BOOLEAN", Boolean.class);
        dbTypeToJavaTypeMap.put("BLOB", byte[].class);
        dbTypeToJavaTypeMap.put("ENUM", String.class);
    }

    public static enum DbVendor {
        MYSQL,
        ORACLE,
        SQLSERVER,
        POSTGRESQL;

    }
}

