/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGL_WebResourceCompressor {
    private static final Logger logger = LoggerFactory.getLogger(MGL_WebResourceCompressor.class);

    private static String getMatch(String str, String pattern) {
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(str);
        if (m.find()) {
            return m.group();
        }
        return "";
    }

    public static String compressJSForInHTML(String htmlStr) throws Exception {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        int i = 0;
        StringBuilder sb = new StringBuilder(0);
        String scriptStartTag = "<script[^>]*?>";
        String scriptEndTag = "<\\/script>";
        while (m_script.find()) {
            String group = m_script.group();
            String matchContent = group.replaceAll(scriptStartTag, "").replaceAll(scriptEndTag, "");
            if (StringUtils.isBlank((CharSequence)matchContent)) continue;
            String com = MGL_WebResourceCompressor.compressJS(matchContent);
            String s = MGL_WebResourceCompressor.getMatch(group, scriptStartTag).concat(com.replaceAll("\\$", "RDS_CHAR_DOLLAR")).concat(MGL_WebResourceCompressor.getMatch(group, scriptEndTag));
            m_script.appendReplacement(sb, MGL_WebResourceCompressor.getMatch(group, scriptStartTag).concat(com.replaceAll("\\$", "RDS_CHAR_DOLLAR").replaceAll("\\\\", "BACK_SLASH")).concat(MGL_WebResourceCompressor.getMatch(group, scriptEndTag)));
            ++i;
        }
        m_script.appendTail(sb);
        return sb.toString().replaceAll("RDS_CHAR_DOLLAR", "\\$").replaceAll("BACK_SLASH", "\\\\");
    }

    public static String compressHtml(String html) throws Exception {
        return MGL_WebResourceCompressor.compressHtml(html, null);
    }

    public static void compressHtmlFile(String htmlPath) throws Exception {
        MGL_WebResourceCompressor.compressHtmlFile(htmlPath, null);
    }

    public static void compressHtmlFile(String htmlPath, List<String> preservePatterns) throws Exception {
        File file = new File(htmlPath);
        String compressHtml = MGL_WebResourceCompressor.compressHtml(Files.readString(file.toPath()), preservePatterns);
        Files.writeString(file.toPath(), (CharSequence)compressHtml, new OpenOption[0]);
    }

    public static String compressHtml(String html, List<String> preservePatterns) throws Exception {
        HtmlCompressor compressor = new HtmlCompressor();
        compressor.setRemoveComments(true);
        compressor.setRemoveIntertagSpaces(true);
        compressor.setRemoveMultiSpaces(true);
        compressor.setRemoveQuotes(true);
        compressor.setEnabled(true);
        compressor.setCompressCss(true);
        compressor.setYuiJsPreserveAllSemiColons(true);
        compressor.setYuiJsLineBreak(1);
        compressor.setPreserveLineBreaks(false);
        if (preservePatterns != null && !preservePatterns.isEmpty()) {
            List<Pattern> patternList = preservePatterns.stream().map(Pattern::compile).toList();
            compressor.setPreservePatterns(patternList);
        }
        String compress = compressor.compress(html);
        try {
            return MGL_WebResourceCompressor.compressJSForInHTML(compress);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String setUrlForChn(String url) throws Exception {
        String regEx = "[\u4e00-\u9fa5]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(url);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            m.appendReplacement(sb, URLEncoder.encode(m.group(), StandardCharsets.UTF_8));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String compressCss(String css) throws IOException {
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        CompilationLevel.WHITESPACE_ONLY.setOptionsForCompilationLevel(options);
        List<SourceFile> input = List.of(SourceFile.fromCode((String)"input.css", (String)css));
        List externs = List.of();
        Result result = compiler.compile(externs, input, options);
        if (result.success) {
            System.out.println(compiler.toSource());
            return compiler.toSource();
        }
        System.err.println("CSS minification failed.");
        return css;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compressJS(String source) throws Exception {
        CompilerOptions compilerOptions = new CompilerOptions();
        CompilationLevel compilationLevel = CompilationLevel.WHITESPACE_ONLY;
        Compiler compiler = new Compiler();
        compilerOptions.setLineBreak(true);
        compilerOptions.setEmitUseStrict(false);
        compilationLevel.setOptionsForCompilationLevel(compilerOptions);
        compiler.disableThreads();
        Compiler.setLoggingLevel((Level)Level.SEVERE);
        StringWriter writer = new StringWriter();
        try {
            List externList = AbstractCommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)CompilerOptions.Environment.BROWSER);
            ArrayList<SourceFile> input = new ArrayList<SourceFile>();
            input.add(SourceFile.fromCode((String)"source.js", (String)source));
            Result result = compiler.compile(externList, input, compilerOptions);
            if (result.success) {
                String string = compiler.toSource();
                return string;
            }
            System.err.println("JS minification failed.");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            writer.flush();
            writer.close();
        }
        return source;
    }
}

