/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import java.util.regex.Pattern;

public class MGL_UnifiedSocialCreditCodeValidator {
    private static final String REGEX = "^[0-9A-HJ-NPQRTUWXY]{2}\\d{6}[0-9A-HJ-NPQRTUWXY]{10}$";
    private static final int[] WEIGHTS = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
    private static final char[] BASE_CODE_ARRAY = "0123456789ABCDEFGHJKLMNPQRTUWXY".toCharArray();
    private static final String BASE_CODE_STRING = "0123456789ABCDEFGHJKLMNPQRTUWXY";

    public static boolean isValid(String code) {
        if (code == null || code.length() != 18) {
            return false;
        }
        if (!Pattern.matches(REGEX, code)) {
            return false;
        }
        return MGL_UnifiedSocialCreditCodeValidator.checkSum(code);
    }

    private static boolean checkSum(String code) {
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            char c = code.charAt(i);
            int codeValue = BASE_CODE_STRING.indexOf(c);
            sum += codeValue * WEIGHTS[i];
        }
        int mod = sum % 31;
        int checkCodeValue = 31 - mod;
        checkCodeValue = checkCodeValue == 31 ? 0 : checkCodeValue;
        return code.charAt(17) == BASE_CODE_ARRAY[checkCodeValue];
    }

    public static void main(String[] args) {
        String testCode = "91150105MA0PX9LN67";
        System.out.println(MGL_UnifiedSocialCreditCodeValidator.isValid(testCode));
    }
}

