/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class MGL_ServletUtils {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private static final Pattern IPV6_PATTERN = Pattern.compile("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9])?[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9])?[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9])?[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9])?[0-9]))");

    public static void setDownloadHeader(String fileName, Long fileSize, HttpServletResponse response) {
        String tempName = new String(fileName.getBytes(), Charset.forName("ISO8859-1"));
        response.setContentType("application/octet-stream; charset=ISO8859-1");
        response.setHeader("Content-Disposition", "attachment;filename=" + tempName);
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.addHeader("Content-Length", "" + fileSize);
    }

    public static String getClientIpAddress(HttpServletRequest request) {
        if (request == null) {
            return "unknown";
        }
        String ip = request.getHeader("X-Forwarded-For");
        if (MGL_ServletUtils.isValidIp(ip)) {
            return MGL_ServletUtils.getFirstIp(ip);
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (MGL_ServletUtils.isValidIp(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (MGL_ServletUtils.isValidIp(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_CLIENT_IP");
        if (MGL_ServletUtils.isValidIp(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        if (MGL_ServletUtils.isValidIp(ip)) {
            return MGL_ServletUtils.getFirstIp(ip);
        }
        ip = request.getRemoteAddr();
        return ip;
    }

    public static String getClientIpFromSocket(Socket socket) {
        if (socket == null) {
            return "unknown";
        }
        InetAddress address = socket.getInetAddress();
        return address != null ? address.getHostAddress() : "unknown";
    }

    public static String getClientIpFromDatagramPacket(DatagramPacket packet) {
        if (packet == null) {
            return "unknown";
        }
        InetAddress address = packet.getAddress();
        return address != null ? address.getHostAddress() : "unknown";
    }

    private static boolean isValidIp(String ip) {
        return ip != null && !ip.isEmpty() && !"unknown".equalsIgnoreCase(ip);
    }

    private static String getFirstIp(String ip) {
        String[] ipArray;
        for (String ipPart : ipArray = ip.split(",")) {
            if (!IPV4_PATTERN.matcher(ipPart = ipPart.trim()).matches() && !IPV6_PATTERN.matcher(ipPart).matches()) continue;
            return ipPart;
        }
        return "unknown";
    }

    public static String getIpVersion(String ip) {
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
            return "unknown";
        }
        if (IPV4_PATTERN.matcher(ip).matches()) {
            return "IPv4";
        }
        if (IPV6_PATTERN.matcher(ip).matches()) {
            return "IPv6";
        }
        return "unknown";
    }
}

