/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import java.util.Iterator;
import java.util.ServiceLoader;

public class MGL_ServiceLoaderUtils {
    public static <T> T loadFirstAvailable(Class<T> service) {
        return MGL_ServiceLoaderUtils.loadFirstAvailable(service, null);
    }

    public static <T> T loadFirstAvailable(Class<T> service, T defaultValue) {
        ServiceLoader<T> loader = ServiceLoader.load(service);
        Iterator<T> iterator = loader.iterator();
        if (iterator.hasNext()) {
            T impl = iterator.next();
            return impl;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalStateException("No implementation found for " + service.getName());
    }

    public static <T> ServiceLoader<T> loadAvailable(Class<T> service) {
        ServiceLoader<T> loader = ServiceLoader.load(service);
        if (loader.stream().findAny().isEmpty()) {
            throw new IllegalStateException("No implementation found for " + service.getName());
        }
        return loader;
    }
}

