/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import tech.mgl.annotation.excel.MGLExcelCell;
import tech.mgl.annotation.excel.MGLExcelModel;
import tech.mgl.core.utils.MGL_TimeUtils;
import tech.mgl.exception.GlobalException;

public class MGL_OfficeUtils {
    private static final DecimalFormat df = new DecimalFormat("#");

    public static <T> List<T> readExcel(T t, File file) throws Exception {
        return MGL_OfficeUtils.readExcel(t, new FileInputStream(file), file.getName());
    }

    public static <T> List<T> readExcel(T t, InputStream in, String name) throws Exception {
        HSSFWorkbook book = null;
        if (MGL_OfficeUtils.isExcel2003(name)) {
            book = new HSSFWorkbook(in);
        } else if (MGL_OfficeUtils.isExcel2007(name)) {
            book = new XSSFWorkbook(in);
        } else {
            throw new GlobalException("\u672a\u77e5\u7684\u6587\u4ef6\u985e\u578b");
        }
        Class<?> cls = t.getClass();
        MGLExcelModel md = cls.getAnnotation(MGLExcelModel.class);
        if (md instanceof MGLExcelModel) {
            Sheet sheet = book.getSheetAt(0);
            int rowCount = sheet.getLastRowNum();
            ArrayList list = new ArrayList(0);
            for (int i = 0; i <= rowCount; ++i) {
                Object obj = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                Row row = sheet.getRow(i);
                if (row == null) continue;
                for (PropertyDescriptor descriptor : propertyDescriptors) {
                    Method readMethod;
                    MGLExcelCell ca;
                    String propertyName = descriptor.getName();
                    if (StringUtils.isBlank((CharSequence)propertyName) || propertyName.equals("class") || null == (ca = (readMethod = descriptor.getReadMethod()).getAnnotation(MGLExcelCell.class))) continue;
                    Method writeMethod = descriptor.getWriteMethod();
                    Cell cell = row.getCell(ca.index());
                    if (cell == null) continue;
                    System.out.println(MGL_OfficeUtils.getCellVal(cell));
                    writeMethod.invoke(obj, MGL_OfficeUtils.getCellVal(cell));
                }
                list.add(obj);
                obj = null;
            }
            return list;
        }
        int sheetsNumber = book.getNumberOfSheets();
        Sheet sheet = book.getSheetAt(0);
        int rowCount = sheet.getLastRowNum();
        for (int i = 0; i <= rowCount; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            for (int j = 0; j <= row.getLastCellNum(); ++j) {
                Cell cell = row.getCell(j);
                if (null == cell) continue;
                System.out.println(MGL_OfficeUtils.getCellVal(cell));
            }
        }
        return null;
    }

    private static Object getCellVal(Cell cell) {
        Object v = null;
        short format = cell.getCellStyle().getDataFormat();
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (176 == format) {
                    Date date = DateUtil.getJavaDate((double)cell.getNumericCellValue());
                    v = MGL_TimeUtils.format(date, "yyyy-MM-dd");
                    break;
                }
                v = df.format(cell.getNumericCellValue());
                break;
            }
            case FORMULA: {
                System.out.println("F");
                break;
            }
            case BOOLEAN: {
                v = cell.getBooleanCellValue();
                break;
            }
            case BLANK: {
                System.out.println("B");
                break;
            }
            default: {
                v = cell.getStringCellValue();
            }
        }
        return v;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }

    public static void main(String[] args) throws Exception {
    }
}

