/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class MGL_NumberRoundingUtils {
    public static double round(double value, int scale) {
        return MGL_NumberRoundingUtils.round(value, scale, RoundingMode.HALF_UP);
    }

    public static double round(double value, int scale, RoundingMode mode) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u5c0f\u6570\u4f4d\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(scale, mode);
        return bd.doubleValue();
    }

    public static double roundUp(double value, int scale) {
        return MGL_NumberRoundingUtils.round(value, scale, RoundingMode.UP);
    }

    public static double roundDown(double value, int scale) {
        return MGL_NumberRoundingUtils.round(value, scale, RoundingMode.DOWN);
    }

    public static double roundTowardsZero(double value, int scale) {
        return MGL_NumberRoundingUtils.round(value, scale, RoundingMode.FLOOR);
    }

    public static double roundAwayFromZero(double value, int scale) {
        return MGL_NumberRoundingUtils.round(value, scale, RoundingMode.CEILING);
    }

    public static double roundBankers(double value, int scale) {
        return MGL_NumberRoundingUtils.round(value, scale, RoundingMode.HALF_EVEN);
    }

    public static double roundToSignificantFigures(double value, int precision) {
        if (precision <= 0) {
            throw new IllegalArgumentException("\u6709\u6548\u6570\u5b57\u4f4d\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        if (value == 0.0) {
            return 0.0;
        }
        int scale = precision - (int)Math.floor(Math.log10(Math.abs(value))) - 1;
        return MGL_NumberRoundingUtils.round(value, scale);
    }

    public static String format(double value, int scale) {
        return String.format("%." + scale + "f", value);
    }

    public static double roundToMultiple(double value, double base) {
        return MGL_NumberRoundingUtils.roundToMultiple(value, base, RoundingMode.HALF_UP);
    }

    public static double roundToMultiple(double value, double base, RoundingMode mode) {
        if (base == 0.0) {
            return value;
        }
        BigDecimal bdValue = BigDecimal.valueOf(value);
        BigDecimal bdBase = BigDecimal.valueOf(base);
        BigDecimal divided = bdValue.divide(bdBase, 0, mode);
        return divided.multiply(bdBase).doubleValue();
    }

    public static boolean equals(double d1, double d2, int scale) {
        return Math.abs(d1 - d2) < Math.pow(10.0, -scale);
    }

    public static void main(String[] args) {
        double number = 123.456789;
        System.out.println("\u56db\u820d\u4e94\u5165\u4fdd\u75592\u4f4d\u5c0f\u6570: " + MGL_NumberRoundingUtils.round(number, 2));
        System.out.println("\u5411\u4e0a\u53d6\u6574\u4fdd\u75592\u4f4d\u5c0f\u6570: " + MGL_NumberRoundingUtils.roundUp(number, 2));
        System.out.println("\u5411\u4e0b\u53d6\u6574\u4fdd\u75592\u4f4d\u5c0f\u6570: " + MGL_NumberRoundingUtils.roundDown(number, 2));
        System.out.println("\u94f6\u884c\u5bb6\u7b97\u6cd5\u4fee\u7ea6: " + MGL_NumberRoundingUtils.roundBankers(2.5, 0));
        System.out.println("\u94f6\u884c\u5bb6\u7b97\u6cd5\u4fee\u7ea6: " + MGL_NumberRoundingUtils.roundBankers(3.5, 0));
        System.out.println("\u4fdd\u75593\u4f4d\u6709\u6548\u6570\u5b57: " + MGL_NumberRoundingUtils.roundToSignificantFigures(123.456789, 3));
        System.out.println("\u4fee\u7ea6\u52300.05\u7684\u500d\u6570: " + MGL_NumberRoundingUtils.roundToMultiple(1.87, 0.05));
    }
}

